% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_table.R
\name{summary_table}
\alias{summary_table}
\title{Summary Table with Optional Group Comparisons}
\usage{
summary_table(
  data,
  group_by = NULL,
  normality_test = "S-W",
  all = FALSE,
  effect_size = FALSE,
  exclude = NULL
)
}
\arguments{
\item{data}{Dataframe containing the variables to be summarized.}

\item{group_by}{Character string indicating the name of the grouping variable for two-group comparisons. Default: NULL.}

\item{normality_test}{Character string indicating the normality test to use: 'S-W' for Shapiro-Wilk or 'K-S' for Kolmogorov-Smirnov. Default: 'S-W'.}

\item{all}{Logical parameter that shows all calculated statistics. Default: FALSE.}

\item{effect_size}{Logical parameter that includes effect size estimates. Default: FALSE.}

\item{exclude}{Character vector of variable names to exclude from the summary. Default: NULL.}
}
\value{
A gt table object with formatted summary statistics.
}
\description{
Generates a summary table for biostatistics and clinical data analysis with
automatic normality, effect size, and statistical test calculations. Handles both
numeric and categorical variables, performing appropriate descriptive statistics
and inferential tests for single-group summaries or two-group comparisons.
}
\examples{
# Simulated clinical data
clinical_df <- clinical_data()

# Overall summary without considering treatment groups
summary_table(clinical_df,
              exclude = c('participant_id', 'visit'))

# Grouped summary by treatment group
summary_table(clinical_df,
              group_by = 'treatment',
              exclude = c('participant_id', 'visit'))

# Grouped summary by treatment group with all stats and effect size
summary_table(clinical_df,
              group_by = 'treatment',
              all = TRUE,
              effect_size = TRUE,
              exclude = c('participant_id', 'visit'))
              
}
