% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_CI.R
\name{mean_CI}
\alias{mean_CI}
\title{Construct the Confidence Interval for the Mean}
\usage{
mean_CI(data, conf.level = 0.95, alternative = "two.sided")
}
\arguments{
\item{data}{A numeric vector from which the mean and confidence interval
will be calculated.}

\item{conf.level}{A numeric value representing the confidence level for the
confidence interval estimation. Default is 0.95.}

\item{alternative}{The alternative hypothesis to be considered on the
confidence interval estimation.
Options are 'two.sided' (default), 'greater', or 'less'.}
}
\value{
A named numeric vector with the mean and the lower and upper bounds
of the confidence interval.
}
\description{
Constructs a confidence interval (CI) for the mean of a numeric vector using the
Student's t-distribution. The CI is calculated based on the specified degrees of
freedom, confidence level, and alternative hypothesis.
}
\examples{
# Example data
values = c(5.2, 4.8, 6.3, 6.1, 7.2, 3.5, 4.9, 2.2, 3.7, 3.5, 8.9)

# Construct a 95\% confidence interval for the mean
mean_CI(values)
}
