% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipdma.impute.R
\name{ipdma.impute}
\alias{ipdma.impute}
\title{Impute missing data in individual participant data with two treatments (i.e. placebo and a treatment).}
\usage{
ipdma.impute(
  dataset = NULL,
  covariates = NULL,
  typeofvar = NULL,
  sys_impute_method = "2l.2stage",
  interaction = NULL,
  meth = NULL,
  pred = NULL,
  studyname = NULL,
  treatmentname = NULL,
  outcomename = NULL,
  m = 5
)
}
\arguments{
\item{dataset}{data which contains variables of interests}

\item{covariates}{vector of variable names to find missing data pattern}

\item{typeofvar}{type of covariate variables; should be a vector of these values: "continuous", "binary", or "count".
Order should follow that of covariates parameter specified. Covariates that are specified "binary" are automatically factored.}

\item{sys_impute_method}{method used for systematically missing studies. Options are "2l.glm", "2l.2stage", or "2l.jomo". Default is set to "2l.2stage".
There is also an option to ignore all the clustering level and impute using predictive mean matching by setting this parameter to "pmm".}

\item{interaction}{indicator denoting whether treatment-covariate interactions should be included. Default is set to true.}

\item{meth}{imputation method to be used in the mice package. If left unspecified, function picks a reasonable one.}

\item{pred}{correct prediction matrix to be used in the mice package. If left unspecified, function picks a reasonable one.}

\item{studyname}{study name in the data specified.}

\item{treatmentname}{treatment name in the data specified.}

\item{outcomename}{outcome name in the data specified.}

\item{m}{number of imputed datasets. Default is set to 5.}
}
\value{
\item{missingPattern}{missing pattern object returned by running findMissingPattern function}
\item{meth}{imputation method used with the mice function}
\item{pred}{prediction matrix used with the mice function}
\item{imp}{imputed datasets that is returned from the mice function}
\item{imp.list}{imputed datasets in a list format}
}
\description{
Impute missing data in individual participant data with two treatments. Data is clustered by different studies.
In the presence of systematically missing variables, the function defaults to 2l.2stage.norm, 2l.2stage.bin, 
and 2l.2stage.pois methods in micemd package. 
If there are no systematically missing variables, the function defaults to use 2l.pmm in miceadds package 
which generalizes predictive mean matching using linear mixed model.
If there is only one study available, the function defaults to use pmm in mice package.
}
\examples{
# load in mice packages
# library(mice) #for datasets with only one study level
# library(miceadds) #for multilevel datasets without systematically missing predictors
# library(micemd) #for multilevel datasets with systematically missing predictors.
simulated_dataset <- generate_sysmiss_ipdma_example(Nstudies = 10, Ncov = 5, sys_missing_prob = 0.3, 
magnitude = 0.2, heterogeneity = 0.1)
\donttest{
imputation <- ipdma.impute(simulated_dataset, covariates = c("x1", "x2", "x3", "x4", "x5"), 
typeofvar = c("continuous", "binary", "binary", "continuous", "continuous"), interaction = TRUE, 
studyname = "study", treatmentname = "treat", outcomename = "y", m = 5)
}
}
