% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{fit.measures}
\alias{fit.measures}
\title{Compute measures of fit for biplot.}
\usage{
fit.measures(bp)
}
\arguments{
\item{bp}{an object of class \code{biplot}.}
}
\value{
An object of class \code{biplot}. The object is augmented with
additional items, depending on the type of biplot object.
\item{quality}{overall quality of fit.}
\item{adequacy}{adequacy of representation of variables.}

For an object of class \code{PCA}:
\item{axis.predictivity}{fit measure of each individual axis.}
\item{sample.predictivity}{fit measure for each individual sample.}
For an object of class \code{CVA}:
\item{axis.predictivity}{fit measure of each individual axis.}
\item{class.predictivity}{fit measure for each class mean.}
\item{within.class.axis.predictivity}{fit measure for each axis based on values
expressed as deviations from their class means.}
\item{within.class.sample.predictivity}{fit measure for each sample expressed as
deviation from its class mean.}
}
\description{
Compute measures of fit for biplot.
}
\examples{
out <- biplot (iris[,1:4]) |> PCA() |> fit.measures()
summary(out)
}
