% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/words.R
\name{word_frequency}
\alias{word_frequency}
\title{Count the per-year frequency of words}
\usage{
word_frequency(key, words, use_canonical = FALSE, start_year = 1800,
  end_year = 2012, ...)
}
\arguments{
\item{key}{a Wordnik API key. These can be obtained
at the \href{http://developer.wordnik.com/}{Wordnik developer portal}.}

\item{words}{a vector of words.}

\item{use_canonical}{whether to use the stemmed, canonical form of the word
(i.e. 'cat', for 'cats') instead of the actual \code{word}. FALSE by default.
Note that for pronunciations specifically, setting it to TRUE may get a wider
range of pronunciations; you should experiment.}

\item{start_year}{the earliest year to get frequencies for. 1800 (the earliest
accepted value) by default.}

\item{end_year}{the latest year to get frequencies for. 2012 (the latest accepted
value) by default.}

\item{...}{further arguments to pass to httr's GET.}
}
\value{
a data.frame of 3 columns; \code{word}, \code{year} and \code{frequency}.
}
\description{
\code{word_frequency} provides, for a vector of words,
the number of appearances each word made per year in the source texts Wordnik
uses.
}
\examples{
\dontrun{
cats_versus_dogs <- word_frequency(key = "notarealkey", words = c("cat", "dog"))
}

}
