% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_class.R
\name{bi_class}
\alias{bi_class}
\title{Create Classes for Bivariate Maps}
\usage{
bi_class(.data, x, y, style = "quantile", dim = 3, keep_factors = FALSE)
}
\arguments{
\item{.data}{A data frame, tibble, or \code{sf} object}

\item{x}{The \code{x} variable}

\item{y}{The \code{y} variable}

\item{style}{A string identifying the style used to calculate breaks. Currently
supported styles are \code{"quantile"} (default), \code{"equal"}, \code{"fisher"},
and \code{"jenks"}.}

\item{dim}{The dimensions of the palette, either \code{2} for a two-by-two palette or
\code{3} for a three-by-three palette.}

\item{keep_factors}{A logical scalar; if \code{TRUE}, the intermediate factor
variables created as part of the calculation of \code{bi_class} will be
retained. If \code{FALSE} (default), they will not be returned.}
}
\value{
A copy of \code{.data} with a new variable \code{bi_class} that contains
    combinations of values that correspond to an observations values for \code{x}
    and \code{y}. This is the basis for applying a bivariate color palette.
}
\description{
Creates mapping classes for a bivariate map. These data will be stored
    in a new variable named \code{bi_class}, which will be added to the given
    data object.
}
\examples{
# quantile breaks, 2x2
data <- bi_class(stl_race_income, x = pctWhite, y = medInc, style = "quantile", dim = 2)

# summarize quantile breaks, 2x2
table(data$bi_class)

# quantile breaks, 3x3
data <- bi_class(stl_race_income, x = pctWhite, y = medInc, style = "quantile", dim = 3)

# summarize quantile breaks, 3x3
table(data$bi_class)

# equal breaks
data <- bi_class(stl_race_income, x = pctWhite, y = medInc, style = "equal", dim = 3)

# summarize equal breaks, 3x3
table(data$bi_class)

# fisher breaks
data <- bi_class(stl_race_income, x = pctWhite, y = medInc, style = "fisher", dim = 3)

# summarize fisher breaks, 3x3
table(data$bi_class)

# jenks breaks
data <- bi_class(stl_race_income, x = pctWhite, y = medInc, style = "jenks", dim = 3)

# summarize jenks breaks, 3x3
table(data$bi_class)

}
