% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_edit.R
\name{bm_edit}
\alias{bm_edit}
\title{Edit a bitmap via text editor}
\usage{
bm_edit(bitmap, editor = getOption("editor"))
}
\arguments{
\item{bitmap}{\code{\link[=bm_bitmap]{bm_bitmap()}} object.
It will be coerced into a binary bitmap via \code{\link[=bm_clamp]{bm_clamp()}}.}

\item{editor}{Text editor.  See \code{\link[utils:file.edit]{utils::file.edit()}} for more information.}
}
\value{
A \code{\link[=bm_bitmap]{bm_bitmap()}} object.
}
\description{
Edit a binary bitmap in a text editor.
}
\details{
Represent zeroes with a \code{.} and ones with a \code{@}
(as in the \code{yaff} font format).  You may
also add/delete rows/columns but the bitmap must
be rectangular.
}
\examples{
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)
  r <- font[[str2ucp("R")]]

  # requires users to manually close file in text editor
  \dontrun{
    edited_r <- bm_edit(r)
    print(edited_r)
  }
}
