% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust.date.R
\name{adjust.date}
\alias{adjust.date}
\alias{adjust.next}
\alias{adjust.none}
\alias{adjust.previous}
\alias{following}
\alias{modified.following}
\alias{modified.preceding}
\alias{preceding}
\title{Adjusts the given dates to the next/previous business day}
\usage{
adjust.next(dates, cal)

following(dates, cal)

adjust.none(dates, cal)

modified.following(dates, cal)

adjust.previous(dates, cal)

preceding(dates, cal)

modified.preceding(dates, cal)
}
\arguments{
\item{dates}{dates to be adjusted}

\item{cal}{an instance of \code{Calendar}}
}
\value{
\code{Date} objects adjusted accordingly.
}
\description{
If the given dates are business days it returns the given dates, but once it
is not, it returns the next/previous business days.
}
\section{Date types accepted}{


The argument \code{dates} accepts \code{Date} objects and any
object that returns a valid \code{Date} object when passed through
\code{as.Date}, which include all \code{POSIX*} classes and \code{character}
objects with ISO formatted dates.
}
\examples{
cal <- create.calendar("Brazil/ANBIMA", holidaysANBIMA, weekdays=c("saturday", "sunday"))
adjust.next("2013-01-01", "Brazil/ANBIMA")
following("2013-01-01", cal)
modified.following("2016-01-31", cal)
adjust.previous("2013-01-01", cal)
preceding("2013-01-01", cal)
modified.preceding("2016-01-01", cal)
}

