% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_dist_fns.R
\name{zinb}
\alias{zinb}
\alias{dzinb}
\alias{pzinb}
\alias{qzinb}
\alias{rzinb}
\title{The zero-inflated negative binomial (ZINB) distribution}
\usage{
dzinb(
  x,
  size,
  psi,
  mu = NULL,
  prob = NULL,
  lower.tail = TRUE,
  log = FALSE,
  recycle = FALSE
)

pzinb(
  q,
  size,
  psi,
  mu = NULL,
  prob = NULL,
  lower.tail = TRUE,
  log.p = FALSE,
  recycle = FALSE
)

qzinb(
  p,
  size,
  psi,
  mu = NULL,
  prob = NULL,
  lower.tail = TRUE,
  log.p = FALSE,
  recycle = FALSE
)

rzinb(n, size, psi, mu = NULL, prob = NULL, recycle = FALSE)
}
\arguments{
\item{x, q}{Vector of quantiles at which to evaluate the PMF and CDF,
respectively. Should be non-negative integers.}

\item{size}{The inverse dispersion parameter, or number of successful trials,
both for the negative binomial portion of the ZINB mixture distribution.
See \code{\link[stats:dnbinom]{nbinom}}.}

\item{psi}{Vector of zero-inflation probabilities.}

\item{mu}{Vector of means for the count portion of the zero-inflated negative
binomial distribution. Only one of \code{mu} or \code{prob} should be specified, not
both. Should be non-negative. NOTE: This is \emph{not} the mean of the ZINB
distribution; it is the mean of the NB component of the mixture
distribution. See \code{\link[stats:dnbinom]{nbinom}}.}

\item{prob}{The probability of success on each trial in the negative binomial portion of the mixture distribution. Only one of \code{mu} or
\code{prob} should be specified, not both. See \code{\link[stats:dnbinom]{nbinom}}.}

\item{lower.tail}{Logical indicating whether probabilities should be
\eqn{Pr(X \le x)} or \eqn{Pr(X > x)}}

\item{log, log.p}{Logical indicating whether probabilities should be returned
on log scale (for \code{dzip} and \code{pzip}), or are supplied on log-scale (for \code{qzip}).}

\item{recycle}{Logical indicating whether to permit arbitrary recycling of
arguments with unequal length. See 'Details' and 'Examples.'}

\item{p}{Vector of probabilities at which to evaluate the quantile function.}

\item{n}{Number of realizations to generate from the distribution}
}
\value{
\code{dzinb} returns the mass function evaluated at \code{x},
\code{pzinb} returns the CDF evaluated at \code{q}, \code{qzinb} returns the quantile
function evaluated at \code{p}, and \code{rzinb} returns random realizations with the
specified parameters.
}
\description{
These functions are used to evaluate the zero-inflated negative binomial
distribution's probability mass function (PMF), cumulative distribution
function (CDF), and quantile function (inverse CDF), as well as generate
random realizations from the ZINB distribution.
}
\examples{
# zero-inflated negative binomial examples

# two unique lengthed arguments, one is length 1 though. No error.

dzinb(4, size=.25, mu= c(1,2,3), psi=c(.2, .1, .15))


# two unique lengthed arguments, one of them is not length 1
# error
\dontrun{

     dzinb(5, size=c(.25, .3), mu= c(1,2,3), psi=c(.2, .1, .15))

}


# two unique lengthed arguments, one of them is not length 1, set
# recycle = T, no error but can give innacurate results.

dzinb(5, size=c(.25, .3), mu= c(1,2,3), psi=c(.2, .1, .15), recycle=TRUE)
}
\references{
Lambert, Diane. "Zero-inflated Poisson regression, with an
application to defects in manufacturing." Technometrics 34.1 (1992): 1-14.
}
\author{
John Niehaus
}
