% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictorResponseFunctions.R
\name{PredictorResponseBivar}
\alias{PredictorResponseBivar}
\title{Predict the exposure-response function at a new grid of points}
\usage{
PredictorResponseBivar(fit, y = NULL, Z = NULL, X = NULL,
  z.pairs = NULL, method = "approx", ngrid = 50, q.fixed = 0.5,
  sel = NULL, min.plot.dist = 0.5, center = TRUE, z.names = colnames(Z),
  verbose = TRUE, ...)
}
\arguments{
\item{fit}{An object containing the results returned by a the \code{kmbayes} function}

\item{y}{a vector of outcome data of length \code{n}.}

\item{Z}{an \code{n}-by-\code{M} matrix of predictor variables to be included in the \code{h} function. Each row represents an observation and each column represents an predictor.}

\item{X}{an \code{n}-by-\code{K} matrix of covariate data where each row represents an observation and each column represents a covariate. Should not contain an intercept column.}

\item{z.pairs}{data frame showing which pairs of pollutants to plot}

\item{method}{method for obtaining posterior summaries at a vector of new points. Options are "approx" and "exact"; defaults to "approx", which is faster particularly for large datasets; see details}

\item{ngrid}{number of grid points in each dimension}

\item{q.fixed}{vector of quantiles at which to fix the remaining predictors in \code{Z}}

\item{sel}{logical expression indicating samples to keep; defaults to keeping the second half of all samples}

\item{min.plot.dist}{specifies a minimum distance that a new grid point needs to be from an observed data point in order to compute the prediction; points further than this will not be computed}

\item{center}{flag for whether to scale the exposure-response function to have mean zero}

\item{z.names}{optional vector of names for the columns of \code{z}}

\item{verbose}{TRUE or FALSE: flag of whether to print intermediate output to the screen}

\item{...}{other argumentd to pass on to the prediction function}
}
\description{
Predict the exposure-response function at a new grid of points
}
\details{
For guided examples, go to \url{https://jenfb.github.io/bkmr/overview.html}
}
