% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fwf_blaise.R
\name{write_fwf_blaise}
\alias{write_fwf_blaise}
\title{Write a fixed width ascii datafile and accompanying blaise datamodel}
\usage{
write_fwf_blaise(
  df,
  output_data,
  output_model = NULL,
  decimal.mark = ".",
  digits = getOption("digits"),
  justify = "right",
  write_model = TRUE,
  model_name = NULL
)
}
\arguments{
\item{df}{dataframe to write}

\item{output_data}{path and name to output datafile. Will add .asc if no extension}

\item{output_model}{path and name to output datamodel. If NULL will use the
same name as output_data with .bla extension.}

\item{decimal.mark}{decimal mark to use. Default is ".".}

\item{digits}{how many significant digits are to be used for numeric and
complex x. The default uses getOption("digits"). This is a suggestion:
enough decimal places will be used so that the smallest (in magnitude) number
has this many significant digits.}

\item{justify}{direction of padding for STRING type when data is smaller than the width.
Defaults to right-justified (padded on the left), can be "left", "right" or "centre".}

\item{write_model}{logical that can be used to disable the automatic writing of a
datamodel}

\item{model_name}{Custom name that can be given to the datamodel. Default is the
name of the dataframe}
}
\value{
output as it is written to file as a character vector.
Does so invisibly, will not print but can be assigned.
}
\description{
Write a datafile in the blaise format (fwf ascii without separators)
will always write out a blaise datamodel describing the datafile as well
}
\details{
Currently supports the following dataformats:
\itemize{
  \item character => STRING,
  \item integer => INTEGER,
  \item numeric => REAL,
  \item Date => DATETYPE,
  \item factor => ENUM (will convert factor with numbers as labels to STRING)
  \item logical => INTEGER
}
}
\examples{
datafilename = tempfile('testdata', fileext = '.asc')
blafilename = tempfile('testbla', fileext = '.bla')
data = data.frame(1, 1:10, sample(LETTERS[1:3], 10, replace = TRUE), runif(10, 1, 10))
write_fwf_blaise(data, datafilename)
unlink(c(datafilename, blafilename))

}
