% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blandr.plot.limits.r
\name{blandr.plot.limits}
\alias{blandr.plot.limits}
\title{Bland-Altman plot limits for R}
\usage{
blandr.plot.limits(statistics.results, lowest_y_axis = FALSE,
  highest_y_axis = FALSE)
}
\arguments{
\item{statistics.results}{A list of statistics generated by the blandr.statistics function: see the function's return list to see what variables are passed to this function}

\item{lowest_y_axis}{(Optional) Defaults to NULL If given a continuous variable will use this as the lower boundary of the y axis. Useful if need multiple plots with equivalent y-axes.}

\item{highest_y_axis}{(Optional) Defaults to NULL If given a continuous variable will use this as the upper boundary of the y axis. Useful if need multiple plots with equivalent y-axes.}
}
\value{
x_upper The upper limit of the X-axis

x_lower The lower limit of the X-axis

y_upper The upper limit of the Y-axis

y_lower The lower limit of the Y-axis
}
\description{
Works out plot limits for the Bland-Altman plots. Depends on the blandr.statistics function in the package.
}
\examples{
# Generates two random measurements
measurement1 <- rnorm(100)
measurement2 <- rnorm(100)

# Passes data to the blandr.statistics function to generate Bland-Altman statistics
statistics.results <- blandr.statistics( measurement1 , measurement2 )

# Calls the function
blandr.plot.limits( statistics.results )

}
\author{
Deepankar Datta <deepankardatta@nhs.net>
}
