% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latent.R
\name{latent}
\alias{latent}
\title{Declares latent variables in a blatent model}
\usage{
latent(
  unit = "rows",
  distribution = "bernoulli",
  structure = "univariate",
  link = "probit",
  type = "ordinal",
  meanIdentification = NULL,
  varianceIdentification = NULL,
  joint = NULL,
  vars = NULL
)
}
\arguments{
\item{unit}{Attaches the unit (person) ID number or label to observations in data. Currently only allows "rows" which indicates each
row of the data is a separate unit in the model. Defaults to \code{"rows"}.}

\item{distribution}{Specifies the distribution of the latent variable(s) to which the function points. Defaults to \code{"bernoulli"}.
 Distributions currently available are:
\itemize{
  \item \code{"bernoulli"}: Specifies each variable follows a Bernoulli distribution (structure must be "univariate").
  \item \code{"mvbernoulli"}: Specifies that set of variables follow a multivariate Bernoulli distribution (structure must be "joint").
}}

\item{structure}{Specifies the type of distributional structure for the latent variables. Defaults to \code{"univariate"}.
 Structures current available are:
\itemize{
  \item \code{"univariate"}: Specifies each variable is modeled using a univariate (marginal or conditional) distribution.
  \item \code{"joint"}: Specifies that variables are modeled using a joint distribution (distribution must be "mvbernoulli")
}}

\item{link}{Specifies the link function used for any latent variable model where the latent variable is predicted.
  Defaults to \code{"probit"}. Link functions currently available are:
\itemize{
  \item \code{"probit"}: Uses a probit link function. Available for variables where \code{distribution = "bernoulli"} only.
}}

\item{type}{Specifies the type of latent variable to be estimated. Defaults to \code{"ordinal"}.
  Types currently available are:
\itemize{
  \item \code{"ordinal"}: Specifies that latent variables have ordinal categories. Available for variables where
    \code{distribution = "bernoulli"} only.
}}

\item{meanIdentification}{Reserved for future use.}

\item{varianceIdentification}{Reserved for future use.}

\item{joint}{Specifies the name of the joint distribution of latent variables. Defaults to \code{NULL}. Used only when
structure is "joint".}

\item{vars}{Reserved for future use.}
}
\description{
Used in \code{\link{blatentSyntax}} to declare latent variables as an unevaluated function call.
  Sets specifications used in estimation.
}
