% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-.R
\name{cmd_wd}
\alias{cmd_wd}
\alias{cmd_envvar}
\alias{cmd_envpath}
\title{Define the environment when running the command}
\usage{
cmd_wd(command, wd = NULL)

cmd_envvar(command, ..., action = "replace", sep = " ")

cmd_envpath(command, ..., action = "prefix", name = "PATH")
}
\arguments{
\item{command}{A \code{command} object.}

\item{wd}{A string or \code{NULL} define the working directory of the command.}

\item{...}{\itemize{
\item \code{cmd_envvar}: Named character define the environment variables.
\item \code{cmd_envpath}: Unnamed character to define the \code{PATH}-like environment
variables \code{name}.
}}

\item{action}{Should the new values \code{"replace"}, \code{"prefix"} or \code{"suffix"}
existing environment variables?}

\item{sep}{A string to separate new and old value when \code{action} is \code{"prefix"}
or \code{"suffix"}.}

\item{name}{A string define the PATH environment variable name. You
can use this to define other \code{PATH}-like environment variable such as
\code{PYTHONPATH}.}
}
\value{
\itemize{
\item \code{cmd_wd}: The \code{command} object itself, with working directory updated.
\item \code{cmd_envvar}: The \code{command} object itself, with running environment
variable updated.
\item \code{cmd_envpath}: The \code{command} object self, with running environment variable
\code{name} updated.
}
}
\description{
\itemize{
\item \code{cmd_wd}: define the working directory.
\item \code{cmd_envvar}: define the environment variables.
\item \code{cmd_envpath}: define the \code{PATH}-like environment variables.
}
}
\seealso{
\code{\link[=cmd_run]{cmd_run()}}/\code{\link[=cmd_background]{cmd_background()}}/\code{\link[=cmd_help]{cmd_help()}}
}
