% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outTeX.R
\name{outTeX}
\alias{outTeX}
\title{Export blocked or assigned data to .tex format files}
\usage{
outTeX(
  block.obj,
  namesCol = NULL,
  file.names = NULL,
  captions = NULL,
  digits = 2,
  ...
)
}
\arguments{
\item{block.obj}{A list of dataframes, such as output from \code{block} or \code{assignment}.}

\item{namesCol}{An optional character vector of column names to be used in output files.}

\item{file.names}{An optional character vector of file names specifying the output file names.}

\item{captions}{An optional character vector of file names specifying the table captions. See Details below.}

\item{digits}{An integer representing the number of decimal places to which to round multivariate distances in output files, passed to \code{round}.}

\item{...}{Additional arguments passed to \code{xtable}.}
}
\value{
A set of .tex files, one for each element of the input list of blocked or assigned units, written by \code{print(xtable)}.
}
\description{
Exports output from \code{block} or \code{assignment} to a set of .tex files using \code{print(xtable)}.
}
\details{
Under the default (\code{file.names = NULL}), each file is named 
\dQuote{GroupXXX.tex}, where \dQuote{XXX} is the group name taken 
from the input object. Under the default (\code{captions = NULL}), 
each caption is \dQuote{Group XXX.}, where \dQuote{XXX} is the group 
name taken from the input object.

\code{outTeX} appends \code{.tex} to the user-specified \code{file.names}.

The table reference labels are created as \code{t:XXX}, where \code{XXX} 
is the file name (without \code{.tex}) for the \code{.tex} file containing that table.

\code{captions} takes a list of strings of length equal to the number of groups 
in \code{block.obj$blocks}, if \code{block.obj} is output from \code{block}, 
or the number of groups in \code{block.obj$assg}, if \code{block.obj} is output 
from \code{assignment}.

The tables in the output .tex files can be integrated into an existing .tex document 
using LaTeX code \samp{\\include{GroupXXX}}.
}
\examples{
data(x100)

# Block and assign:
out <- block(x100, groups = "g", n.tr = 2, id.vars = "id", block.vars = c("b1", "b2"))
assg <- assignment(out, seed = 123)

# create three .tex files of blocks
\dontrun{outTeX(out)}
# create three .tex files of assigned blocks
#   (note: overwrites blocked .tex files)
\dontrun{outTeX(assg)}
# create three .tex files with custom file names and captions
\dontrun{outTeX(assg, file.names = c("f1", "f2", "f3"), captions = c("C 1.", "C 2.", "C 3."))}

}
\seealso{
\code{\link{outCSV}}, \code{\link[xtable]{xtable}}, \code{\link{block}}, \code{\link{assignment}}
}
\author{
Ryan T. Moore
}
\keyword{IO}
\keyword{design}
