% Generated by roxygen2 (4.0.2): do not edit by hand
\name{blocks}
\alias{blocks}
\title{Block designs}
\usage{
blocks(treatments, replicates, blocklevels = HCF(replicates),
  searches = max(1, 100 - sum(treatments) - prod(blocklevels)),
  seed = sample(10000, 1), jumps = 1)
}
\arguments{
\item{treatments}{a set of cardinal numbers where the sum of the cardinals is the required number of treatments and the individual cardinals
represent individual sets of equally replicated treatments}

\item{replicates}{a vector of replication numbers, one for each of the individual treatment sets defined above,
where the replication numbers and the treatment sets are assumed to be in matching order.}

\item{blocklevels}{an optional vector of integers where the first integer is the number of main blocks and the remaining integers, if any,
are the numbers of nested sub-blocks in a hierarchy of nested sub-blocks. The default is the HCF of the replication numbers.}

\item{searches}{an optional integer for the maximum number of searches during optimization. The default is the maximum of 1 or (100 - sum of model terms).}

\item{seed}{an optional integer for initializing the random number generator. The default is a random integer less than 10000.}

\item{jumps}{an optional integer for the number of pairwise random treatment swaps used to escape a local maxima in a stratum. The default is a single swap.}
}
\value{
\item{Design}{Data frame showing the optimized block and treatment factors in plot order}
\item{Plan}{Data frame showing a plan view of the treatments in the bottom stratum of the design}
\item{Incidences}{Blocks-by-treatments incidence matrices in each stratum of the design}
\item{Efficiencies}{The achieved A- and D-efficiencies for each stratum of the design together with an A-efficiency upper-bound, where available}
\item{seed}{Numerical seed for random number generator}
\item{searches}{Maximum number of searches in each stratum}
\item{jumps}{Number of random treatment swaps to escape a local maxima}
}
\description{
Constructs randomized nested block designs for unstructured treatments with arbitrary replication,
not necessarily all equal, and arbitrary depth of nesting.
}
\details{
The \code{blocks} function optimizes nested blocks designs where treatments can have any arbitrary level of replication, not necessarily all equal,
and blocks can be either a simple main blocks design or a nested blocks design with any feasible depth of nesting.

The \code{treatments} and \code{replicates} arguments define the treatment structure of the design. \code{treatments} is a
set of cardinal numbers that define sets of equally replicated treatments and \code{replicates} is a matching set of replication numbers for those sets.
The sum of the cardinal numbers is the total number of treatments and the sum of the cross-products of the cardinal numbers and the replication
numbers is the total number of units. Treatments are numbered consecutively according to the ordering of the treatment sets but
 different sets with the same replication can be used if arbitrary numbering is required.
 Single replicate treatments sets are permitted provided there are at least some replicated treatment sets in the design.

The \code{blocklevels} argument is a vector of integers that defines the blocks structure of the design. The length of the vector is the total number of
strata while the numeric elements are the block levels of the successive strata.
The first number is the number of main blocks, the second, if any, is the number of sub-blocks nested in each main block, the third, if any,
is the number of sub-sub-blocks nested in each sub-block and so on. The default is a main blocks design with the maximum possible number of
orthogonal main blocks. Block sizes are always as equal as possible and will never differ by more than a single unit
in any one stratum.

The \code{searches} argument is the integer number of searches for an optimization. Ideally, the number of searches should be as large
 as the computational resources permit.

The \code{jumps} argument is the number of random swaps needed to escape a local maxima. A single swap appears to work well and
is the most efficient choice for the updating algorithm but the setting can be increased to any integer value, if required.

There are three classes of solution for the designs defined by the above arguments:
\itemize{

\item Complete block designs constructed algebraically by direct substitution of complete treatment sets. Complete blocks can contain multiple
sets of treatments but the equal block size restriction means that the number of blocks must divide the number of treatment replicates (see example).

\item Lattice block designs with k replicates of v**2 treatments in k main blocks where each main block contains
v incomplete blocks of size v and k < (v+2) for prime or prime-power v, or k < 5 for v = 10 or k < 4 for any other v. Lattice designs are constructed
by algebraic methods using Latin squares. The \code{\link[crossdes]{MOLS}} package is used if v is a prime-power.

\item  General block designs with arbitrary depth of nesting. These designs are optimized by making D-efficiency improving swaps between
blocks nested within the constraints of higher level blocks, if any, until a local maxima is attained.
For repeated \code{searches}, a local maxima is escaped by one or more random swaps (= \code{jumps}) between blocks, again nested within
 the constraints of higher level blocks, if any.
The algorithm works from the top stratum downwards and the design of each nested stratum is conditional on
the design of all higher level strata. The efficiency of nested designs may be slightly reduced relative to the efficiency of comparable non-nested designs
but, for all practical purposes, this reduction is of no practical consequence.

}

 The principle design outputs comprise:
\itemize{
 \item  A design matrix showing the allocation of treatments to blocks with the successive stratum blocks arranged in successive columns in standard block order.  \cr
 \item  A design matrix as above but with the bottom stratum blocks arranged in a plan view. \cr
 \item  A set of incidence matrices, one for each stratum, showing the number of times each treatment occurs in each block for each stratum. \cr
 \item  A table showing the achieved D- and A-efficiency factors for each nested blocks stratum together with an A-efficiency upper bound, where available. \cr
}
}
\examples{
# 3 treatments x 2 replicates, 2 treatments x 4 replicates and 4 treatments x 3 replicates
# the hcf of the replication numbers is 1 therefore the default design is completely randomized
blocks(treatments=c(3,2,4),replicates=c(2,4,3))

# 4 treatments x 4 replicates with 2 main blocks each containing two complete replicates
blocks(treatments=4,replicates=4,blocklevel=2)

# 50 treatments x 4 replicates with 4 main blocks and 5 nested sub-blocks in each main block
blocks(treatments=50,replicates=4,blocklevels=c(4,5))

# as above but with 20 additional single replicate treatments
# giving exactly one single replicate treatment per sub-block
blocks(treatments=c(50,20),replicates=c(4,1),blocklevels=c(4,5))

# 64 treatments x 2 replicates with 2 main blocks and five succesively nested 2-level factors
blocks(treatments=64,replicates=2,blocklevels=c(2,2,2,2,2,2))

# concurrence matrix of balanced incomplete block design
crossprod(blocks(13,4,13,searches=100)$Incidences[[1]])

# concurrence matrix for 13 treatments x 4 replicates and 13 treatments with one rep in 13 blocks
crossprod(blocks(c(13,13),c(4,1),13)$Incidences[[1]])
}
\references{
Sailer, M. O. (2013). crossdes: Construction of Crossover Designs. R package version 1.1-1. http://CRAN.R-project.org/package=crossdes
}

