% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pairwise_effics.r
\name{efficiencies}
\alias{efficiencies}
\title{Efficiencies of pairwise differences.}
\usage{
efficiencies(Design)
}
\arguments{
\item{Design}{a design data frame generated by \code{\link[blocksdesign]{blocks}}.}
}
\value{
\item{Efficiencies}{List of treatments efficiency matrices for all pairwise differences for each stratum of the design}
}
\description{
Tabulates the efficieny of pairwise treatment difference for each stratum of a design constructed by \code{\link[blocksdesign]{blocks}}.
}
\details{
Tabulates the efficiency factors of the pairwise treatment differences in every statum of any design built by the \code{blocks} function.
 For equi-replicate block designs, the harmonic mean of the pairwise efficiency factors will equal the A-efficiency factor.
}
\examples{
# 4 replicates of 50 treatments in complete randomized blocks
efficiencies(blocks(treatments=50,replicates=4,blocklevels=c(4,5))$Design)
}

