% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabsel-class.R
\docType{methods}
\name{evolution}
\alias{evolution}
\alias{evolution,stab.blockSeg-method}
\title{Plot method for a stab.blockSeg object}
\usage{
evolution(x, y,...)

\S4method{evolution}{stab.blockSeg}(x, y, thresholds = 10 * (8:1),
  postprocessing = list(post = TRUE, adjacent = 2), col = "GrayLevel",
  ask = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{stab.blockSeg}.}

\item{y}{the observations data (or a transformation).}

\item{...}{used for S4 compatibility.}

\item{thresholds}{the thresholds used (percent the maximum value). By default, thresholds = 10 * (8:1).}

\item{postprocessing}{the condition if plot used a post-processing (if $post=TRUE) or not. 
If there is a post-processing, post-processing$adjacent is the maximal distance between two points.}

\item{col}{colours of the graphics. By default, it is "GrayLevel" to black and white colours. 
If it is another "character", it is a level blue or red. Else, it is possible to propose a sequence with 
the colour (rgb format).}

\item{ask}{If \code{TRUE}, to hit will be necessary to see next plot.}
}
\description{
Produce a plot of two-dimensional segmentation of a \code{stab.blockSeg} fit.
}
\examples{
n <- 100
## model parameters 
K <- 5
mu <- suppressWarnings(matrix(rep(c(1,0),ceiling(K**2/2)), K,K))
Y <- rblockdata(n,mu,sigma=.5)$Y
stab.out <- stab.blockSeg(Y, 100, 15)
evolution(stab.out,Y)

}
\seealso{
\code{\linkS4class{stab.blockSeg}}.
}

