% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criteria-class.R
\docType{methods}
\name{criteria}
\alias{criteria}
\alias{criteria,blockSeg-method}
\title{Penalized criteria based on estimation of degrees of freedom}
\usage{
criteria(object, Y, penalty = setNames(c(2, log(length(Y))), c("AIC", "BIC")),
  sigma = NULL, log.scale = TRUE, xvar = "lambda", plot = TRUE)

\S4method{criteria}{blockSeg}(object, Y, penalty = setNames(c(2,
  log(length(Y))), c("AIC", "BIC")), sigma = NULL, log.scale = TRUE,
  xvar = "lambda", plot = TRUE)
}
\arguments{
\item{object}{output of a fitting procedure of the \pkg{blockseg}
package (e.g. \code{\link{blockSeg}}). Must be of class
\code{blockSeg}.}

\item{Y}{matrix of observations.}

\item{penalty}{a vector with as many penalties a desired. The
default contains the penalty corresponding to the AIC and the BIC
(\eqn{2}{2} and \eqn{\log(n)}{log(n)}). Setting the "names"
attribute, as done in the default definition, leads to outputs
which are easier to read.}

\item{sigma}{scalar: an estimate of the residual variance. When
available, it is plugged-in the criteria, which may be more
relevant. If \code{NULL} (the default), it is estimated as usual
(see details).}

\item{log.scale}{logical; indicates if a log-scale should be used
when \code{xvar="lambda"}. Default is \code{TRUE}.}

\item{xvar}{variable to plot on the X-axis: either \code{"df"}
(the estimated degrees of freedom), \code{"lambda"}
(\eqn{\lambda_1}{lambda1} penalty level) or \code{"fraction"}
(\eqn{\ell_1}{l1}-norm of the coefficients). Default is set to
\code{"lambda"}.}

\item{plot}{logical; indicates if the graph should be plotted on
call. Default is \code{TRUE}.}
}
\value{
When \code{plot} is set to \code{TRUE}, an invisible
\pkg{ggplot2} object is returned, which can be plotted via the
\code{print} method. On the other hand, a list with a two data
frames containing the criteria and the chosen vector of parameters
are returned.
}
\description{
Produce a plot or send back the values of some penalized criteria
accompanied with the vector(s) of parameters selected
accordingly. The default behavior plots the BIC and the AIC (with
respective factor \eqn{\log(n)}{log(n)} and \eqn{2}{2}) yet the user can specify any
penalty.
}
\note{
When \code{sigma} is provided, the criterion takes the form

\if{latex}{\deqn{\left\|\mathbf{y} - \mathbf{X} \hat{\beta} \right\|^2 +
\mathrm{penalty} \times \frac{\hat{\mathrm{df}}}{n} \ \sigma^2.}}
\if{html}{\out{ <center> RSS + penalty * df / n * sigma<sup>2</sup> </center>}}
\if{text}{\deqn{RSS + penalty * df / n * sigma^2}}

When it is unknown, it writes

\if{latex}{\deqn{\log\left(\left\|\mathbf{y} - \mathbf{X} \hat{\beta} \right\|^2\right) +
\mathrm{penalty} \times \hat{\mathrm{df}}.}}
\if{html}{\out{ <center> n*log(RSS) + penalty * df </center>}}
\if{text}{\deqn{n*log(RSS) + penalty * df}}

Estimation of the degrees of freedom (for the elastic-net, the
LASSO and also bounded regression) are computed by applying and
adapting the results of Tibshirani and Taylor (see references
below).
}
\examples{
n <- 100
K <- 5
mu <- suppressWarnings(matrix(rep(c(1,0),ceiling(K**2/2)), K,K))
Y <- rblockdata(n,mu,sigma=.5)$Y
res <- blockSeg(Y, 50)
criteria(res, Y, sigma=.5)

}
\references{
Ryan Tibshirani and Jonathan Taylor. Degrees of
freedom in lasso problems, Annals of Statistics, 40(2) 2012.
}
\seealso{
\code{\linkS4class{blockSeg}}.
}
