% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serve.R
\name{serve_site}
\alias{serve_site}
\alias{stop_server}
\title{Live preview a site}
\usage{
serve_site(..., .site_dir = NULL)

stop_server()
}
\arguments{
\item{...}{Arguments passed to \code{servr::\link[servr]{server_config}()}
(only arguments \code{host}, \code{port}, \code{browser}, \code{daemon},
and \code{interval} are supported).}

\item{.site_dir}{Directory to search for site configuration file. It defaults
to \code{getwd()}, and can also be specified via the global option
\code{blogdown.site_root}.}
}
\description{
The function \code{serve_site()} executes the server command of a static site
generator (e.g., \command{hugo server} or \command{jekyll server}) to start a
local web server, which watches for changes in the site, rebuilds the site if
necessary, and refreshes the web page automatically; \code{stop_server()}
stops the web server.
}
\details{
By default, the server also watches for changes in R Markdown files, and
recompile them automatically if they are modified. This means they will be
automatically recompiled once you save them. If you do not like this
behavior, you may set \code{options(blogdown.knit.on_save = FALSE)} (ideally
in your \file{.Rprofile}). When this feature is disabled, you will have to
manually compile Rmd documents, e.g., by clicking the Knit button in RStudio.

The site generator is defined by the global R option
\code{blogdown.generator}, with the default being \code{'hugo'}. You may use
other site generators including \code{jekyll} and \code{hexo}, e.g.,
\code{options(blogdown.generator = 'jekyll')}. You can define command-line
arguments to be passed to the server of the site generator via the global R
option \code{blogdown.X.server}, where \code{X} is \code{hugo},
\code{jekyll}, or \code{hexo}. The default for Hugo is
\code{options(blogdown.hugo.server = c('-D', '-F', '--navigateToChanged'))}
(see the documentation of Hugo server at
\url{https://gohugo.io/commands/hugo_server/} for the meaning of these
arguments).
}
\note{
For the Hugo server, the argument \command{--navigateToChanged} is used
  by default, which means when you edit and save a source file, Hugo will
  automatically navigate the web browser to the page corresponding to this
  source file (if the page exists).
}
