% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-woe-iv.R
\name{blr_woe_iv}
\alias{blr_woe_iv}
\alias{plot.blr_woe_iv}
\title{WoE & IV}
\usage{
blr_woe_iv(data, predictor, response, digits = 4, ...)

\method{plot}{blr_woe_iv}(
  x,
  title = NA,
  xaxis_title = "Levels",
  yaxis_title = "WoE",
  bar_color = "blue",
  line_color = "red",
  print_plot = TRUE,
  ...
)
}
\arguments{
\item{data}{A \code{tibble} or \code{data.frame}.}

\item{predictor}{Predictor variable; column in \code{data}.}

\item{response}{Response variable; column in \code{data}.}

\item{digits}{Number of decimal digits to round off.}

\item{...}{Other inputs.}

\item{x}{An object of class \code{blr_segment_dist}.}

\item{title}{Plot title.}

\item{xaxis_title}{X axis title.}

\item{yaxis_title}{Y axis title.}

\item{bar_color}{Color of the bar.}

\item{line_color}{Color of the horizontal line.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
A tibble.
}
\description{
Weight of evidence and information value. Currently avialable for categorical
  predictors only.
}
\examples{
# woe and iv
k <- blr_woe_iv(hsb2, female, honcomp)
k

# plot woe
plot(k)

}
\references{
Siddiqi  N  (2006):  Credit  Risk  Scorecards:  developing  and  implementing  intelligent
credit  scoring. New Jersey, Wiley.
}
\seealso{
Other bivariate analysis procedures: 
\code{\link{blr_bivariate_analysis}()},
\code{\link{blr_segment_dist}()},
\code{\link{blr_segment_twoway}()},
\code{\link{blr_segment}()},
\code{\link{blr_woe_iv_stats}()}
}
\concept{bivariate analysis procedures}
