% Generated by roxygen2 (4.0.0): do not edit by hand
\name{addDots}
\alias{addDots}
\title{Extend a function's signature to include '...'}
\usage{
addDots(func, .verbose = FALSE)
}
\arguments{
\item{func}{the function whose signature is to be modified.}

\item{.verbose}{logical flag indicating whether warnings should be displayed
or not.}
}
\value{
a function with the same body as \code{func} but whose signature now
includes \code{...}.
}
\description{
modifies the input function to accept extra arguments,
if it doesn't already.
}
\examples{
\dontrun{
f <- function(x,y) x^2 + y^2

g <- addDots(f)
g

h <- addDots(g, .verbose=TRUE)}
}

