% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_tables.R
\name{data_as_tidy_table}
\alias{data_as_tidy_table}
\title{Convert a list of data entries as returned by BLS API to a table}
\usage{
data_as_tidy_table(data)
}
\arguments{
\item{data}{a list of individual datum entries as returned the API}
}
\value{
tibble flattening \code{data} into rows for entries and columns for fields
}
\description{
Convert a list of data entries as returned by BLS API to a table
}
\details{
An extension of \code{\link{data_as_table}} that replaces the BLS period
format by removing columns \code{period} and \code{periodName} and adding \code{month} or
\code{quarter} where appropriate.
}
\examples{
\dontrun{
series <- get_series('LNS14000001')
table <- data_as_tidy_table(series$data)
}
}
\seealso{
Other blsR-utils: 
\code{\link{data_as_table}()},
\code{\link{merge_tables}()},
\code{\link{merge_tidy_tables}()},
\code{\link{tidy_periods}()}
}
\concept{blsR-utils}
