
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_bmlm_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_bmlm : public prob_grad {
private:
    int N;
    int J;
    vector<int> id;
    vector_d X;
    vector_d M;
    double prior_dm;
    double prior_dy;
    double prior_a;
    double prior_b;
    double prior_cp;
    double prior_tau_dm;
    double prior_tau_dy;
    double prior_tau_a;
    double prior_tau_b;
    double prior_tau_cp;
    double prior_lkj_shape;
    vector_d Y;
    int K;
public:
    model_bmlm(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_bmlm(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_bmlm_namespace::model_bmlm";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "J", "int", context__.to_vec());
        J = int(0);
        vals_i__ = context__.vals_i("J");
        pos__ = 0;
        J = vals_i__[pos__++];
        context__.validate_dims("data initialization", "id", "int", context__.to_vec(N));
        validate_non_negative_index("id", "N", N);
        id = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("id");
        pos__ = 0;
        size_t id_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < id_limit_0__; ++i_0__) {
            id[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("X", "N", N);
        X = vector_d(static_cast<Eigen::VectorXd::Index>(N));
        context__.validate_dims("data initialization", "X", "vector_d", context__.to_vec(N));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_i_vec_lim__ = N;
        for (size_t i_vec__ = 0; i_vec__ < X_i_vec_lim__; ++i_vec__) {
            X[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("M", "N", N);
        M = vector_d(static_cast<Eigen::VectorXd::Index>(N));
        context__.validate_dims("data initialization", "M", "vector_d", context__.to_vec(N));
        vals_r__ = context__.vals_r("M");
        pos__ = 0;
        size_t M_i_vec_lim__ = N;
        for (size_t i_vec__ = 0; i_vec__ < M_i_vec_lim__; ++i_vec__) {
            M[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_dm", "double", context__.to_vec());
        prior_dm = double(0);
        vals_r__ = context__.vals_r("prior_dm");
        pos__ = 0;
        prior_dm = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_dy", "double", context__.to_vec());
        prior_dy = double(0);
        vals_r__ = context__.vals_r("prior_dy");
        pos__ = 0;
        prior_dy = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_a", "double", context__.to_vec());
        prior_a = double(0);
        vals_r__ = context__.vals_r("prior_a");
        pos__ = 0;
        prior_a = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_b", "double", context__.to_vec());
        prior_b = double(0);
        vals_r__ = context__.vals_r("prior_b");
        pos__ = 0;
        prior_b = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_cp", "double", context__.to_vec());
        prior_cp = double(0);
        vals_r__ = context__.vals_r("prior_cp");
        pos__ = 0;
        prior_cp = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_tau_dm", "double", context__.to_vec());
        prior_tau_dm = double(0);
        vals_r__ = context__.vals_r("prior_tau_dm");
        pos__ = 0;
        prior_tau_dm = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_tau_dy", "double", context__.to_vec());
        prior_tau_dy = double(0);
        vals_r__ = context__.vals_r("prior_tau_dy");
        pos__ = 0;
        prior_tau_dy = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_tau_a", "double", context__.to_vec());
        prior_tau_a = double(0);
        vals_r__ = context__.vals_r("prior_tau_a");
        pos__ = 0;
        prior_tau_a = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_tau_b", "double", context__.to_vec());
        prior_tau_b = double(0);
        vals_r__ = context__.vals_r("prior_tau_b");
        pos__ = 0;
        prior_tau_b = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_tau_cp", "double", context__.to_vec());
        prior_tau_cp = double(0);
        vals_r__ = context__.vals_r("prior_tau_cp");
        pos__ = 0;
        prior_tau_cp = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_lkj_shape", "double", context__.to_vec());
        prior_lkj_shape = double(0);
        vals_r__ = context__.vals_r("prior_lkj_shape");
        pos__ = 0;
        prior_lkj_shape = vals_r__[pos__++];
        validate_non_negative_index("Y", "N", N);
        Y = vector_d(static_cast<Eigen::VectorXd::Index>(N));
        context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(N));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_i_vec_lim__ = N;
        for (size_t i_vec__ = 0; i_vec__ < Y_i_vec_lim__; ++i_vec__) {
            Y[i_vec__] = vals_r__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"J",J,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"id[k0__]",id[k0__],1);
            check_less_or_equal(function__,"id[k0__]",id[k0__],J);
        }
        // initialize data variables
        K = int(0);
        stan::math::fill(K, std::numeric_limits<int>::min());

        try {
            stan::math::assign(K, 5);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += ((K * (K - 1)) / 2);
        num_params_r__ += K;
        num_params_r__ += K * J;
        ++num_params_r__;
    }

    ~model_bmlm() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("dy")))
            throw std::runtime_error("variable dy missing");
        vals_r__ = context__.vals_r("dy");
        pos__ = 0U;
        context__.validate_dims("initialization", "dy", "double", context__.to_vec());
        // generate_declaration dy
        double dy(0);
        dy = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(dy);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable dy: ") + e.what());
        }

        if (!(context__.contains_r("cp")))
            throw std::runtime_error("variable cp missing");
        vals_r__ = context__.vals_r("cp");
        pos__ = 0U;
        context__.validate_dims("initialization", "cp", "double", context__.to_vec());
        // generate_declaration cp
        double cp(0);
        cp = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(cp);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable cp: ") + e.what());
        }

        if (!(context__.contains_r("b")))
            throw std::runtime_error("variable b missing");
        vals_r__ = context__.vals_r("b");
        pos__ = 0U;
        context__.validate_dims("initialization", "b", "double", context__.to_vec());
        // generate_declaration b
        double b(0);
        b = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b: ") + e.what());
        }

        if (!(context__.contains_r("dm")))
            throw std::runtime_error("variable dm missing");
        vals_r__ = context__.vals_r("dm");
        pos__ = 0U;
        context__.validate_dims("initialization", "dm", "double", context__.to_vec());
        // generate_declaration dm
        double dm(0);
        dm = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(dm);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable dm: ") + e.what());
        }

        if (!(context__.contains_r("a")))
            throw std::runtime_error("variable a missing");
        vals_r__ = context__.vals_r("a");
        pos__ = 0U;
        context__.validate_dims("initialization", "a", "double", context__.to_vec());
        // generate_declaration a
        double a(0);
        a = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(a);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable a: ") + e.what());
        }

        if (!(context__.contains_r("sigma_m")))
            throw std::runtime_error("variable sigma_m missing");
        vals_r__ = context__.vals_r("sigma_m");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_m", "double", context__.to_vec());
        // generate_declaration sigma_m
        double sigma_m(0);
        sigma_m = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_m: ") + e.what());
        }

        if (!(context__.contains_r("L_Omega")))
            throw std::runtime_error("variable L_Omega missing");
        vals_r__ = context__.vals_r("L_Omega");
        pos__ = 0U;
        context__.validate_dims("initialization", "L_Omega", "matrix_d", context__.to_vec(K,K));
        // generate_declaration L_Omega
        matrix_d L_Omega(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>(K));
        for (int j2__ = 0U; j2__ < K; ++j2__)
            for (int j1__ = 0U; j1__ < K; ++j1__)
                L_Omega(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.cholesky_corr_unconstrain(L_Omega);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable L_Omega: ") + e.what());
        }

        if (!(context__.contains_r("Tau")))
            throw std::runtime_error("variable Tau missing");
        vals_r__ = context__.vals_r("Tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "Tau", "vector_d", context__.to_vec(K));
        // generate_declaration Tau
        vector_d Tau(static_cast<Eigen::VectorXd::Index>(K));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            Tau(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,Tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable Tau: ") + e.what());
        }

        if (!(context__.contains_r("z_U")))
            throw std::runtime_error("variable z_U missing");
        vals_r__ = context__.vals_r("z_U");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_U", "matrix_d", context__.to_vec(K,J));
        // generate_declaration z_U
        matrix_d z_U(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>(J));
        for (int j2__ = 0U; j2__ < J; ++j2__)
            for (int j1__ = 0U; j1__ < K; ++j1__)
                z_U(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.matrix_unconstrain(z_U);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_U: ") + e.what());
        }

        if (!(context__.contains_r("sigma_y")))
            throw std::runtime_error("variable sigma_y missing");
        vals_r__ = context__.vals_r("sigma_y");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_y", "double", context__.to_vec());
        // generate_declaration sigma_y
        double sigma_y(0);
        sigma_y = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_y);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_y: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ dy;
        (void) dy;  // dummy to suppress unused var warning
        if (jacobian__)
            dy = in__.scalar_constrain(lp__);
        else
            dy = in__.scalar_constrain();

        T__ cp;
        (void) cp;  // dummy to suppress unused var warning
        if (jacobian__)
            cp = in__.scalar_constrain(lp__);
        else
            cp = in__.scalar_constrain();

        T__ b;
        (void) b;  // dummy to suppress unused var warning
        if (jacobian__)
            b = in__.scalar_constrain(lp__);
        else
            b = in__.scalar_constrain();

        T__ dm;
        (void) dm;  // dummy to suppress unused var warning
        if (jacobian__)
            dm = in__.scalar_constrain(lp__);
        else
            dm = in__.scalar_constrain();

        T__ a;
        (void) a;  // dummy to suppress unused var warning
        if (jacobian__)
            a = in__.scalar_constrain(lp__);
        else
            a = in__.scalar_constrain();

        T__ sigma_m;
        (void) sigma_m;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_m = in__.scalar_lb_constrain(0,lp__);
        else
            sigma_m = in__.scalar_lb_constrain(0);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  L_Omega;
        (void) L_Omega;  // dummy to suppress unused var warning
        if (jacobian__)
            L_Omega = in__.cholesky_corr_constrain(K,lp__);
        else
            L_Omega = in__.cholesky_corr_constrain(K);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  Tau;
        (void) Tau;  // dummy to suppress unused var warning
        if (jacobian__)
            Tau = in__.vector_lb_constrain(0,K,lp__);
        else
            Tau = in__.vector_lb_constrain(0,K);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  z_U;
        (void) z_U;  // dummy to suppress unused var warning
        if (jacobian__)
            z_U = in__.matrix_constrain(K,J,lp__);
        else
            z_U = in__.matrix_constrain(K,J);

        T__ sigma_y;
        (void) sigma_y;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_y = in__.scalar_lb_constrain(0,lp__);
        else
            sigma_y = in__.scalar_lb_constrain(0);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  U(static_cast<Eigen::VectorXd::Index>(J),static_cast<Eigen::VectorXd::Index>(K));
        (void) U;  // dummy to suppress unused var warning
        stan::math::initialize(U, DUMMY_VAR__);
        stan::math::fill(U,DUMMY_VAR__);


        try {
            stan::math::assign(U, transpose(multiply(diag_pre_multiply(Tau,L_Omega),z_U)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < J; ++i0__) {
            for (int i1__ = 0; i1__ < K; ++i1__) {
                if (stan::math::is_uninitialized(U(i0__,i1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: U" << '[' << i0__ << ']' << '[' << i1__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_y(static_cast<Eigen::VectorXd::Index>(N));
                (void) mu_y;  // dummy to suppress unused var warning
                stan::math::initialize(mu_y, DUMMY_VAR__);
                stan::math::fill(mu_y,DUMMY_VAR__);
                Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_m(static_cast<Eigen::VectorXd::Index>(N));
                (void) mu_m;  // dummy to suppress unused var warning
                stan::math::initialize(mu_m, DUMMY_VAR__);
                stan::math::fill(mu_m,DUMMY_VAR__);
                Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  L_Sigma(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>(K));
                (void) L_Sigma;  // dummy to suppress unused var warning
                stan::math::initialize(L_Sigma, DUMMY_VAR__);
                stan::math::fill(L_Sigma,DUMMY_VAR__);


                lp_accum__.add(normal_log<propto__>(dy, 0, prior_dy));
                lp_accum__.add(normal_log<propto__>(dm, 0, prior_dm));
                lp_accum__.add(normal_log<propto__>(a, 0, prior_a));
                lp_accum__.add(normal_log<propto__>(b, 0, prior_b));
                lp_accum__.add(normal_log<propto__>(cp, 0, prior_cp));
                lp_accum__.add(cauchy_log<propto__>(get_base1(Tau,1,"Tau",1), 0, prior_tau_cp));
                lp_accum__.add(cauchy_log<propto__>(get_base1(Tau,2,"Tau",1), 0, prior_tau_b));
                lp_accum__.add(cauchy_log<propto__>(get_base1(Tau,3,"Tau",1), 0, prior_tau_a));
                lp_accum__.add(cauchy_log<propto__>(get_base1(Tau,4,"Tau",1), 0, prior_tau_dy));
                lp_accum__.add(cauchy_log<propto__>(get_base1(Tau,5,"Tau",1), 0, prior_tau_dm));
                lp_accum__.add(lkj_corr_cholesky_log<propto__>(L_Omega, prior_lkj_shape));
                lp_accum__.add(normal_log<propto__>(to_vector(z_U), 0, 1));
                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(mu_y,n,"mu_y",1), ((((cp + get_base1(U,get_base1(id,n,"id",1),1,"U",1)) * get_base1(X,n,"X",1)) + ((b + get_base1(U,get_base1(id,n,"id",1),2,"U",1)) * get_base1(M,n,"M",1))) + (dy + get_base1(U,get_base1(id,n,"id",1),4,"U",1))));
                    stan::math::assign(get_base1_lhs(mu_m,n,"mu_m",1), (((a + get_base1(U,get_base1(id,n,"id",1),3,"U",1)) * get_base1(X,n,"X",1)) + (dm + get_base1(U,get_base1(id,n,"id",1),5,"U",1))));
                }
                lp_accum__.add(normal_log<propto__>(Y, mu_y, sigma_y));
                lp_accum__.add(normal_log<propto__>(M, mu_m, sigma_m));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("dy");
        names__.push_back("cp");
        names__.push_back("b");
        names__.push_back("dm");
        names__.push_back("a");
        names__.push_back("sigma_m");
        names__.push_back("L_Omega");
        names__.push_back("Tau");
        names__.push_back("z_U");
        names__.push_back("sigma_y");
        names__.push_back("U");
        names__.push_back("Omega");
        names__.push_back("Sigma");
        names__.push_back("covab");
        names__.push_back("corrab");
        names__.push_back("me");
        names__.push_back("c");
        names__.push_back("pme");
        names__.push_back("u_a");
        names__.push_back("u_b");
        names__.push_back("u_cp");
        names__.push_back("u_dy");
        names__.push_back("u_dm");
        names__.push_back("u_c");
        names__.push_back("u_me");
        names__.push_back("u_pme");
        names__.push_back("tau_cp");
        names__.push_back("tau_b");
        names__.push_back("tau_a");
        names__.push_back("tau_dy");
        names__.push_back("tau_dm");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_bmlm_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double dy = in__.scalar_constrain();
        double cp = in__.scalar_constrain();
        double b = in__.scalar_constrain();
        double dm = in__.scalar_constrain();
        double a = in__.scalar_constrain();
        double sigma_m = in__.scalar_lb_constrain(0);
        matrix_d L_Omega = in__.cholesky_corr_constrain(K);
        vector_d Tau = in__.vector_lb_constrain(0,K);
        matrix_d z_U = in__.matrix_constrain(K,J);
        double sigma_y = in__.scalar_lb_constrain(0);
        vars__.push_back(dy);
        vars__.push_back(cp);
        vars__.push_back(b);
        vars__.push_back(dm);
        vars__.push_back(a);
        vars__.push_back(sigma_m);
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
                vars__.push_back(L_Omega(k_0__, k_1__));
            }
        }
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(Tau[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < J; ++k_1__) {
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
                vars__.push_back(z_U(k_0__, k_1__));
            }
        }
        vars__.push_back(sigma_y);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        matrix_d U(static_cast<Eigen::VectorXd::Index>(J),static_cast<Eigen::VectorXd::Index>(K));
        (void) U;  // dummy to suppress unused var warning
        stan::math::initialize(U, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(U,DUMMY_VAR__);


        try {
            stan::math::assign(U, transpose(multiply(diag_pre_multiply(Tau,L_Omega),z_U)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
                vars__.push_back(U(k_0__, k_1__));
            }
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        matrix_d Omega(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>(K));
        (void) Omega;  // dummy to suppress unused var warning
        stan::math::initialize(Omega, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Omega,DUMMY_VAR__);
        matrix_d Sigma(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>(K));
        (void) Sigma;  // dummy to suppress unused var warning
        stan::math::initialize(Sigma, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Sigma,DUMMY_VAR__);
        double covab(0.0);
        (void) covab;  // dummy to suppress unused var warning
        stan::math::initialize(covab, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(covab,DUMMY_VAR__);
        double corrab(0.0);
        (void) corrab;  // dummy to suppress unused var warning
        stan::math::initialize(corrab, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(corrab,DUMMY_VAR__);
        double me(0.0);
        (void) me;  // dummy to suppress unused var warning
        stan::math::initialize(me, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(me,DUMMY_VAR__);
        double c(0.0);
        (void) c;  // dummy to suppress unused var warning
        stan::math::initialize(c, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(c,DUMMY_VAR__);
        double pme(0.0);
        (void) pme;  // dummy to suppress unused var warning
        stan::math::initialize(pme, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pme,DUMMY_VAR__);
        vector_d u_a(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_a;  // dummy to suppress unused var warning
        stan::math::initialize(u_a, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_a,DUMMY_VAR__);
        vector_d u_b(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_b;  // dummy to suppress unused var warning
        stan::math::initialize(u_b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_b,DUMMY_VAR__);
        vector_d u_cp(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_cp;  // dummy to suppress unused var warning
        stan::math::initialize(u_cp, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_cp,DUMMY_VAR__);
        vector_d u_dy(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_dy;  // dummy to suppress unused var warning
        stan::math::initialize(u_dy, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_dy,DUMMY_VAR__);
        vector_d u_dm(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_dm;  // dummy to suppress unused var warning
        stan::math::initialize(u_dm, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_dm,DUMMY_VAR__);
        vector_d u_c(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_c;  // dummy to suppress unused var warning
        stan::math::initialize(u_c, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_c,DUMMY_VAR__);
        vector_d u_me(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_me;  // dummy to suppress unused var warning
        stan::math::initialize(u_me, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_me,DUMMY_VAR__);
        vector_d u_pme(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_pme;  // dummy to suppress unused var warning
        stan::math::initialize(u_pme, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_pme,DUMMY_VAR__);
        double tau_cp(0.0);
        (void) tau_cp;  // dummy to suppress unused var warning
        stan::math::initialize(tau_cp, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau_cp,DUMMY_VAR__);
        double tau_b(0.0);
        (void) tau_b;  // dummy to suppress unused var warning
        stan::math::initialize(tau_b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau_b,DUMMY_VAR__);
        double tau_a(0.0);
        (void) tau_a;  // dummy to suppress unused var warning
        stan::math::initialize(tau_a, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau_a,DUMMY_VAR__);
        double tau_dy(0.0);
        (void) tau_dy;  // dummy to suppress unused var warning
        stan::math::initialize(tau_dy, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau_dy,DUMMY_VAR__);
        double tau_dm(0.0);
        (void) tau_dm;  // dummy to suppress unused var warning
        stan::math::initialize(tau_dm, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau_dm,DUMMY_VAR__);


        try {
            stan::math::assign(tau_cp, get_base1(Tau,1,"Tau",1));
            stan::math::assign(tau_b, get_base1(Tau,2,"Tau",1));
            stan::math::assign(tau_a, get_base1(Tau,3,"Tau",1));
            stan::math::assign(tau_dy, get_base1(Tau,4,"Tau",1));
            stan::math::assign(tau_dm, get_base1(Tau,5,"Tau",1));
            stan::math::assign(Omega, multiply(L_Omega,transpose(L_Omega)));
            stan::math::assign(Sigma, quad_form_diag(Omega,Tau));
            stan::math::assign(covab, get_base1(Sigma,3,2,"Sigma",1));
            stan::math::assign(corrab, get_base1(Omega,3,2,"Omega",1));
            stan::math::assign(me, ((a * b) + covab));
            stan::math::assign(c, (cp + me));
            stan::math::assign(pme, (me / c));
            for (int j = 1; j <= J; ++j) {

                stan::math::assign(get_base1_lhs(u_a,j,"u_a",1), (a + get_base1(U,j,3,"U",1)));
                stan::math::assign(get_base1_lhs(u_b,j,"u_b",1), (b + get_base1(U,j,2,"U",1)));
                stan::math::assign(get_base1_lhs(u_me,j,"u_me",1), ((a + get_base1(U,j,3,"U",1)) * (b + get_base1(U,j,2,"U",1))));
                stan::math::assign(get_base1_lhs(u_cp,j,"u_cp",1), (cp + get_base1(U,j,1,"U",1)));
                stan::math::assign(get_base1_lhs(u_dy,j,"u_dy",1), (dy + get_base1(U,j,4,"U",1)));
                stan::math::assign(get_base1_lhs(u_dm,j,"u_dm",1), (dm + get_base1(U,j,5,"U",1)));
                stan::math::assign(get_base1_lhs(u_c,j,"u_c",1), (get_base1(u_cp,j,"u_cp",1) + get_base1(u_me,j,"u_me",1)));
                stan::math::assign(get_base1_lhs(u_pme,j,"u_pme",1), (get_base1(u_me,j,"u_me",1) / get_base1(u_c,j,"u_c",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
                vars__.push_back(Omega(k_0__, k_1__));
            }
        }
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
                vars__.push_back(Sigma(k_0__, k_1__));
            }
        }
        vars__.push_back(covab);
        vars__.push_back(corrab);
        vars__.push_back(me);
        vars__.push_back(c);
        vars__.push_back(pme);
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_a[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_cp[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_dy[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_dm[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_c[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_me[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_pme[k_0__]);
        }
        vars__.push_back(tau_cp);
        vars__.push_back(tau_b);
        vars__.push_back(tau_a);
        vars__.push_back(tau_dy);
        vars__.push_back(tau_dm);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_bmlm";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "dy";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "cp";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "dm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_Omega" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= J; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_U" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "U" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Omega" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "covab";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "corrab";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "me";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "c";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pme";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_a" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_cp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_dy" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_dm" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_c" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_me" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_pme" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_cp";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_dy";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_dm";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "dy";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "cp";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "dm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= ((K * (K - 1)) / 2); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "L_Omega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= J; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_U" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "U" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Omega" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "covab";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "corrab";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "me";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "c";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pme";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_a" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_cp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_dy" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_dm" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_c" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_me" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_pme" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_cp";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_dy";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_dm";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_bmlm_binary_y_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_bmlm_binary_y : public prob_grad {
private:
    int N;
    int J;
    vector<int> id;
    vector_d X;
    vector_d M;
    double prior_dm;
    double prior_dy;
    double prior_a;
    double prior_b;
    double prior_cp;
    double prior_tau_dm;
    double prior_tau_dy;
    double prior_tau_a;
    double prior_tau_b;
    double prior_tau_cp;
    double prior_lkj_shape;
    vector<int> Y;
    int K;
public:
    model_bmlm_binary_y(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_bmlm_binary_y(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_bmlm_binary_y_namespace::model_bmlm_binary_y";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "J", "int", context__.to_vec());
        J = int(0);
        vals_i__ = context__.vals_i("J");
        pos__ = 0;
        J = vals_i__[pos__++];
        context__.validate_dims("data initialization", "id", "int", context__.to_vec(N));
        validate_non_negative_index("id", "N", N);
        id = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("id");
        pos__ = 0;
        size_t id_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < id_limit_0__; ++i_0__) {
            id[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("X", "N", N);
        X = vector_d(static_cast<Eigen::VectorXd::Index>(N));
        context__.validate_dims("data initialization", "X", "vector_d", context__.to_vec(N));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_i_vec_lim__ = N;
        for (size_t i_vec__ = 0; i_vec__ < X_i_vec_lim__; ++i_vec__) {
            X[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("M", "N", N);
        M = vector_d(static_cast<Eigen::VectorXd::Index>(N));
        context__.validate_dims("data initialization", "M", "vector_d", context__.to_vec(N));
        vals_r__ = context__.vals_r("M");
        pos__ = 0;
        size_t M_i_vec_lim__ = N;
        for (size_t i_vec__ = 0; i_vec__ < M_i_vec_lim__; ++i_vec__) {
            M[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "prior_dm", "double", context__.to_vec());
        prior_dm = double(0);
        vals_r__ = context__.vals_r("prior_dm");
        pos__ = 0;
        prior_dm = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_dy", "double", context__.to_vec());
        prior_dy = double(0);
        vals_r__ = context__.vals_r("prior_dy");
        pos__ = 0;
        prior_dy = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_a", "double", context__.to_vec());
        prior_a = double(0);
        vals_r__ = context__.vals_r("prior_a");
        pos__ = 0;
        prior_a = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_b", "double", context__.to_vec());
        prior_b = double(0);
        vals_r__ = context__.vals_r("prior_b");
        pos__ = 0;
        prior_b = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_cp", "double", context__.to_vec());
        prior_cp = double(0);
        vals_r__ = context__.vals_r("prior_cp");
        pos__ = 0;
        prior_cp = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_tau_dm", "double", context__.to_vec());
        prior_tau_dm = double(0);
        vals_r__ = context__.vals_r("prior_tau_dm");
        pos__ = 0;
        prior_tau_dm = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_tau_dy", "double", context__.to_vec());
        prior_tau_dy = double(0);
        vals_r__ = context__.vals_r("prior_tau_dy");
        pos__ = 0;
        prior_tau_dy = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_tau_a", "double", context__.to_vec());
        prior_tau_a = double(0);
        vals_r__ = context__.vals_r("prior_tau_a");
        pos__ = 0;
        prior_tau_a = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_tau_b", "double", context__.to_vec());
        prior_tau_b = double(0);
        vals_r__ = context__.vals_r("prior_tau_b");
        pos__ = 0;
        prior_tau_b = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_tau_cp", "double", context__.to_vec());
        prior_tau_cp = double(0);
        vals_r__ = context__.vals_r("prior_tau_cp");
        pos__ = 0;
        prior_tau_cp = vals_r__[pos__++];
        context__.validate_dims("data initialization", "prior_lkj_shape", "double", context__.to_vec());
        prior_lkj_shape = double(0);
        vals_r__ = context__.vals_r("prior_lkj_shape");
        pos__ = 0;
        prior_lkj_shape = vals_r__[pos__++];
        context__.validate_dims("data initialization", "Y", "int", context__.to_vec(N));
        validate_non_negative_index("Y", "N", N);
        Y = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Y");
        pos__ = 0;
        size_t Y_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Y_limit_0__; ++i_0__) {
            Y[i_0__] = vals_i__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"J",J,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"id[k0__]",id[k0__],1);
            check_less_or_equal(function__,"id[k0__]",id[k0__],J);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Y[k0__]",Y[k0__],0);
            check_less_or_equal(function__,"Y[k0__]",Y[k0__],1);
        }
        // initialize data variables
        K = int(0);
        stan::math::fill(K, std::numeric_limits<int>::min());

        try {
            stan::math::assign(K, 5);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += ((K * (K - 1)) / 2);
        num_params_r__ += K;
        num_params_r__ += K * J;
    }

    ~model_bmlm_binary_y() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("dy")))
            throw std::runtime_error("variable dy missing");
        vals_r__ = context__.vals_r("dy");
        pos__ = 0U;
        context__.validate_dims("initialization", "dy", "double", context__.to_vec());
        // generate_declaration dy
        double dy(0);
        dy = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(dy);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable dy: ") + e.what());
        }

        if (!(context__.contains_r("cp")))
            throw std::runtime_error("variable cp missing");
        vals_r__ = context__.vals_r("cp");
        pos__ = 0U;
        context__.validate_dims("initialization", "cp", "double", context__.to_vec());
        // generate_declaration cp
        double cp(0);
        cp = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(cp);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable cp: ") + e.what());
        }

        if (!(context__.contains_r("b")))
            throw std::runtime_error("variable b missing");
        vals_r__ = context__.vals_r("b");
        pos__ = 0U;
        context__.validate_dims("initialization", "b", "double", context__.to_vec());
        // generate_declaration b
        double b(0);
        b = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b: ") + e.what());
        }

        if (!(context__.contains_r("dm")))
            throw std::runtime_error("variable dm missing");
        vals_r__ = context__.vals_r("dm");
        pos__ = 0U;
        context__.validate_dims("initialization", "dm", "double", context__.to_vec());
        // generate_declaration dm
        double dm(0);
        dm = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(dm);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable dm: ") + e.what());
        }

        if (!(context__.contains_r("a")))
            throw std::runtime_error("variable a missing");
        vals_r__ = context__.vals_r("a");
        pos__ = 0U;
        context__.validate_dims("initialization", "a", "double", context__.to_vec());
        // generate_declaration a
        double a(0);
        a = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(a);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable a: ") + e.what());
        }

        if (!(context__.contains_r("sigma_m")))
            throw std::runtime_error("variable sigma_m missing");
        vals_r__ = context__.vals_r("sigma_m");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_m", "double", context__.to_vec());
        // generate_declaration sigma_m
        double sigma_m(0);
        sigma_m = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_m: ") + e.what());
        }

        if (!(context__.contains_r("L_Omega")))
            throw std::runtime_error("variable L_Omega missing");
        vals_r__ = context__.vals_r("L_Omega");
        pos__ = 0U;
        context__.validate_dims("initialization", "L_Omega", "matrix_d", context__.to_vec(K,K));
        // generate_declaration L_Omega
        matrix_d L_Omega(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>(K));
        for (int j2__ = 0U; j2__ < K; ++j2__)
            for (int j1__ = 0U; j1__ < K; ++j1__)
                L_Omega(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.cholesky_corr_unconstrain(L_Omega);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable L_Omega: ") + e.what());
        }

        if (!(context__.contains_r("Tau")))
            throw std::runtime_error("variable Tau missing");
        vals_r__ = context__.vals_r("Tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "Tau", "vector_d", context__.to_vec(K));
        // generate_declaration Tau
        vector_d Tau(static_cast<Eigen::VectorXd::Index>(K));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            Tau(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,Tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable Tau: ") + e.what());
        }

        if (!(context__.contains_r("z_U")))
            throw std::runtime_error("variable z_U missing");
        vals_r__ = context__.vals_r("z_U");
        pos__ = 0U;
        context__.validate_dims("initialization", "z_U", "matrix_d", context__.to_vec(K,J));
        // generate_declaration z_U
        matrix_d z_U(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>(J));
        for (int j2__ = 0U; j2__ < J; ++j2__)
            for (int j1__ = 0U; j1__ < K; ++j1__)
                z_U(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.matrix_unconstrain(z_U);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z_U: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ dy;
        (void) dy;  // dummy to suppress unused var warning
        if (jacobian__)
            dy = in__.scalar_constrain(lp__);
        else
            dy = in__.scalar_constrain();

        T__ cp;
        (void) cp;  // dummy to suppress unused var warning
        if (jacobian__)
            cp = in__.scalar_constrain(lp__);
        else
            cp = in__.scalar_constrain();

        T__ b;
        (void) b;  // dummy to suppress unused var warning
        if (jacobian__)
            b = in__.scalar_constrain(lp__);
        else
            b = in__.scalar_constrain();

        T__ dm;
        (void) dm;  // dummy to suppress unused var warning
        if (jacobian__)
            dm = in__.scalar_constrain(lp__);
        else
            dm = in__.scalar_constrain();

        T__ a;
        (void) a;  // dummy to suppress unused var warning
        if (jacobian__)
            a = in__.scalar_constrain(lp__);
        else
            a = in__.scalar_constrain();

        T__ sigma_m;
        (void) sigma_m;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_m = in__.scalar_lb_constrain(0,lp__);
        else
            sigma_m = in__.scalar_lb_constrain(0);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  L_Omega;
        (void) L_Omega;  // dummy to suppress unused var warning
        if (jacobian__)
            L_Omega = in__.cholesky_corr_constrain(K,lp__);
        else
            L_Omega = in__.cholesky_corr_constrain(K);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  Tau;
        (void) Tau;  // dummy to suppress unused var warning
        if (jacobian__)
            Tau = in__.vector_lb_constrain(0,K,lp__);
        else
            Tau = in__.vector_lb_constrain(0,K);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  z_U;
        (void) z_U;  // dummy to suppress unused var warning
        if (jacobian__)
            z_U = in__.matrix_constrain(K,J,lp__);
        else
            z_U = in__.matrix_constrain(K,J);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  U(static_cast<Eigen::VectorXd::Index>(J),static_cast<Eigen::VectorXd::Index>(K));
        (void) U;  // dummy to suppress unused var warning
        stan::math::initialize(U, DUMMY_VAR__);
        stan::math::fill(U,DUMMY_VAR__);


        try {
            stan::math::assign(U, transpose(multiply(diag_pre_multiply(Tau,L_Omega),z_U)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < J; ++i0__) {
            for (int i1__ = 0; i1__ < K; ++i1__) {
                if (stan::math::is_uninitialized(U(i0__,i1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: U" << '[' << i0__ << ']' << '[' << i1__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_y(static_cast<Eigen::VectorXd::Index>(N));
                (void) mu_y;  // dummy to suppress unused var warning
                stan::math::initialize(mu_y, DUMMY_VAR__);
                stan::math::fill(mu_y,DUMMY_VAR__);
                Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_m(static_cast<Eigen::VectorXd::Index>(N));
                (void) mu_m;  // dummy to suppress unused var warning
                stan::math::initialize(mu_m, DUMMY_VAR__);
                stan::math::fill(mu_m,DUMMY_VAR__);
                Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  L_Sigma(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>(K));
                (void) L_Sigma;  // dummy to suppress unused var warning
                stan::math::initialize(L_Sigma, DUMMY_VAR__);
                stan::math::fill(L_Sigma,DUMMY_VAR__);


                lp_accum__.add(normal_log<propto__>(dy, 0, prior_dy));
                lp_accum__.add(normal_log<propto__>(dm, 0, prior_dm));
                lp_accum__.add(normal_log<propto__>(a, 0, prior_a));
                lp_accum__.add(normal_log<propto__>(b, 0, prior_b));
                lp_accum__.add(normal_log<propto__>(cp, 0, prior_cp));
                lp_accum__.add(cauchy_log<propto__>(get_base1(Tau,1,"Tau",1), 0, prior_tau_cp));
                lp_accum__.add(cauchy_log<propto__>(get_base1(Tau,2,"Tau",1), 0, prior_tau_b));
                lp_accum__.add(cauchy_log<propto__>(get_base1(Tau,3,"Tau",1), 0, prior_tau_a));
                lp_accum__.add(cauchy_log<propto__>(get_base1(Tau,4,"Tau",1), 0, prior_tau_dy));
                lp_accum__.add(cauchy_log<propto__>(get_base1(Tau,5,"Tau",1), 0, prior_tau_dm));
                lp_accum__.add(lkj_corr_cholesky_log<propto__>(L_Omega, prior_lkj_shape));
                lp_accum__.add(normal_log<propto__>(to_vector(z_U), 0, 1));
                for (int n = 1; n <= N; ++n) {

                    stan::math::assign(get_base1_lhs(mu_y,n,"mu_y",1), ((((cp + get_base1(U,get_base1(id,n,"id",1),1,"U",1)) * get_base1(X,n,"X",1)) + ((b + get_base1(U,get_base1(id,n,"id",1),2,"U",1)) * get_base1(M,n,"M",1))) + (dy + get_base1(U,get_base1(id,n,"id",1),4,"U",1))));
                    stan::math::assign(get_base1_lhs(mu_m,n,"mu_m",1), (((a + get_base1(U,get_base1(id,n,"id",1),3,"U",1)) * get_base1(X,n,"X",1)) + (dm + get_base1(U,get_base1(id,n,"id",1),5,"U",1))));
                }
                lp_accum__.add(bernoulli_logit_log<propto__>(Y, mu_y));
                lp_accum__.add(normal_log<propto__>(M, mu_m, sigma_m));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("dy");
        names__.push_back("cp");
        names__.push_back("b");
        names__.push_back("dm");
        names__.push_back("a");
        names__.push_back("sigma_m");
        names__.push_back("L_Omega");
        names__.push_back("Tau");
        names__.push_back("z_U");
        names__.push_back("U");
        names__.push_back("Omega");
        names__.push_back("Sigma");
        names__.push_back("covab");
        names__.push_back("corrab");
        names__.push_back("me");
        names__.push_back("c");
        names__.push_back("pme");
        names__.push_back("u_a");
        names__.push_back("u_b");
        names__.push_back("u_cp");
        names__.push_back("u_dy");
        names__.push_back("u_dm");
        names__.push_back("u_c");
        names__.push_back("u_me");
        names__.push_back("u_pme");
        names__.push_back("tau_cp");
        names__.push_back("tau_b");
        names__.push_back("tau_a");
        names__.push_back("tau_dy");
        names__.push_back("tau_dm");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_bmlm_binary_y_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double dy = in__.scalar_constrain();
        double cp = in__.scalar_constrain();
        double b = in__.scalar_constrain();
        double dm = in__.scalar_constrain();
        double a = in__.scalar_constrain();
        double sigma_m = in__.scalar_lb_constrain(0);
        matrix_d L_Omega = in__.cholesky_corr_constrain(K);
        vector_d Tau = in__.vector_lb_constrain(0,K);
        matrix_d z_U = in__.matrix_constrain(K,J);
        vars__.push_back(dy);
        vars__.push_back(cp);
        vars__.push_back(b);
        vars__.push_back(dm);
        vars__.push_back(a);
        vars__.push_back(sigma_m);
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
                vars__.push_back(L_Omega(k_0__, k_1__));
            }
        }
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(Tau[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < J; ++k_1__) {
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
                vars__.push_back(z_U(k_0__, k_1__));
            }
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        matrix_d U(static_cast<Eigen::VectorXd::Index>(J),static_cast<Eigen::VectorXd::Index>(K));
        (void) U;  // dummy to suppress unused var warning
        stan::math::initialize(U, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(U,DUMMY_VAR__);


        try {
            stan::math::assign(U, transpose(multiply(diag_pre_multiply(Tau,L_Omega),z_U)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
                vars__.push_back(U(k_0__, k_1__));
            }
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        matrix_d Omega(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>(K));
        (void) Omega;  // dummy to suppress unused var warning
        stan::math::initialize(Omega, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Omega,DUMMY_VAR__);
        matrix_d Sigma(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>(K));
        (void) Sigma;  // dummy to suppress unused var warning
        stan::math::initialize(Sigma, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Sigma,DUMMY_VAR__);
        double covab(0.0);
        (void) covab;  // dummy to suppress unused var warning
        stan::math::initialize(covab, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(covab,DUMMY_VAR__);
        double corrab(0.0);
        (void) corrab;  // dummy to suppress unused var warning
        stan::math::initialize(corrab, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(corrab,DUMMY_VAR__);
        double me(0.0);
        (void) me;  // dummy to suppress unused var warning
        stan::math::initialize(me, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(me,DUMMY_VAR__);
        double c(0.0);
        (void) c;  // dummy to suppress unused var warning
        stan::math::initialize(c, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(c,DUMMY_VAR__);
        double pme(0.0);
        (void) pme;  // dummy to suppress unused var warning
        stan::math::initialize(pme, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pme,DUMMY_VAR__);
        vector_d u_a(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_a;  // dummy to suppress unused var warning
        stan::math::initialize(u_a, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_a,DUMMY_VAR__);
        vector_d u_b(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_b;  // dummy to suppress unused var warning
        stan::math::initialize(u_b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_b,DUMMY_VAR__);
        vector_d u_cp(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_cp;  // dummy to suppress unused var warning
        stan::math::initialize(u_cp, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_cp,DUMMY_VAR__);
        vector_d u_dy(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_dy;  // dummy to suppress unused var warning
        stan::math::initialize(u_dy, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_dy,DUMMY_VAR__);
        vector_d u_dm(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_dm;  // dummy to suppress unused var warning
        stan::math::initialize(u_dm, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_dm,DUMMY_VAR__);
        vector_d u_c(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_c;  // dummy to suppress unused var warning
        stan::math::initialize(u_c, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_c,DUMMY_VAR__);
        vector_d u_me(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_me;  // dummy to suppress unused var warning
        stan::math::initialize(u_me, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_me,DUMMY_VAR__);
        vector_d u_pme(static_cast<Eigen::VectorXd::Index>(J));
        (void) u_pme;  // dummy to suppress unused var warning
        stan::math::initialize(u_pme, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(u_pme,DUMMY_VAR__);
        double tau_cp(0.0);
        (void) tau_cp;  // dummy to suppress unused var warning
        stan::math::initialize(tau_cp, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau_cp,DUMMY_VAR__);
        double tau_b(0.0);
        (void) tau_b;  // dummy to suppress unused var warning
        stan::math::initialize(tau_b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau_b,DUMMY_VAR__);
        double tau_a(0.0);
        (void) tau_a;  // dummy to suppress unused var warning
        stan::math::initialize(tau_a, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau_a,DUMMY_VAR__);
        double tau_dy(0.0);
        (void) tau_dy;  // dummy to suppress unused var warning
        stan::math::initialize(tau_dy, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau_dy,DUMMY_VAR__);
        double tau_dm(0.0);
        (void) tau_dm;  // dummy to suppress unused var warning
        stan::math::initialize(tau_dm, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau_dm,DUMMY_VAR__);


        try {
            stan::math::assign(tau_cp, get_base1(Tau,1,"Tau",1));
            stan::math::assign(tau_b, get_base1(Tau,2,"Tau",1));
            stan::math::assign(tau_a, get_base1(Tau,3,"Tau",1));
            stan::math::assign(tau_dy, get_base1(Tau,4,"Tau",1));
            stan::math::assign(tau_dm, get_base1(Tau,5,"Tau",1));
            stan::math::assign(Omega, multiply(L_Omega,transpose(L_Omega)));
            stan::math::assign(Sigma, quad_form_diag(Omega,Tau));
            stan::math::assign(covab, get_base1(Sigma,3,2,"Sigma",1));
            stan::math::assign(corrab, get_base1(Omega,3,2,"Omega",1));
            stan::math::assign(me, ((a * b) + covab));
            stan::math::assign(c, (cp + me));
            stan::math::assign(pme, (me / c));
            for (int j = 1; j <= J; ++j) {

                stan::math::assign(get_base1_lhs(u_a,j,"u_a",1), (a + get_base1(U,j,3,"U",1)));
                stan::math::assign(get_base1_lhs(u_b,j,"u_b",1), (b + get_base1(U,j,2,"U",1)));
                stan::math::assign(get_base1_lhs(u_me,j,"u_me",1), ((a + get_base1(U,j,3,"U",1)) * (b + get_base1(U,j,2,"U",1))));
                stan::math::assign(get_base1_lhs(u_cp,j,"u_cp",1), (cp + get_base1(U,j,1,"U",1)));
                stan::math::assign(get_base1_lhs(u_dy,j,"u_dy",1), (dy + get_base1(U,j,4,"U",1)));
                stan::math::assign(get_base1_lhs(u_dm,j,"u_dm",1), (dm + get_base1(U,j,5,"U",1)));
                stan::math::assign(get_base1_lhs(u_c,j,"u_c",1), (get_base1(u_cp,j,"u_cp",1) + get_base1(u_me,j,"u_me",1)));
                stan::math::assign(get_base1_lhs(u_pme,j,"u_pme",1), (get_base1(u_me,j,"u_me",1) / get_base1(u_c,j,"u_c",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
                vars__.push_back(Omega(k_0__, k_1__));
            }
        }
        for (int k_1__ = 0; k_1__ < K; ++k_1__) {
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
                vars__.push_back(Sigma(k_0__, k_1__));
            }
        }
        vars__.push_back(covab);
        vars__.push_back(corrab);
        vars__.push_back(me);
        vars__.push_back(c);
        vars__.push_back(pme);
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_a[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_cp[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_dy[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_dm[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_c[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_me[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(u_pme[k_0__]);
        }
        vars__.push_back(tau_cp);
        vars__.push_back(tau_b);
        vars__.push_back(tau_a);
        vars__.push_back(tau_dy);
        vars__.push_back(tau_dm);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_bmlm_binary_y";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "dy";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "cp";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "dm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_Omega" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= J; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_U" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "U" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Omega" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "covab";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "corrab";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "me";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "c";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pme";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_a" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_cp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_dy" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_dm" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_c" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_me" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_pme" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_cp";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_dy";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_dm";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "dy";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "cp";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "dm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= ((K * (K - 1)) / 2); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "L_Omega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= J; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_U" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "U" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Omega" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "covab";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "corrab";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "me";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "c";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pme";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_a" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_cp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_dy" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_dm" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_c" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_me" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_pme" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_cp";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_a";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_dy";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau_dm";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

} // namespace




#endif
