#' Relationship between work stressors, work dissatisfaction,
#' and relationship dissatisfaction.
#'
#' @description Simulated data from Intensive Longitudinal Methods:
#' An Introduction to Diary and Experience Sampling Research.
#' (Bolger, & Laurenceau, 2013, chapter 9;
#' \url{http://www.intensivelongitudinal.com/index.html}).
#'
#' @docType data
#'
#' @usage data(BLch9)
#'
#' @format A data frame with 2100 rows and 8 variables:
#' \describe{
#'   \item{id}{ID of study participant}
#'   \item{time}{Time}
#'   \item{fwkstrs}{Number of work stressors}
#'   \item{fwkdis}{Work dissatisfaction rating}
#'   \item{freldis}{Relationship dissatisfaction}
#'   \item{x}{Subject-mean deviated number of work stressors}
#'   \item{m}{Subject-mean deviated work dissatisfaction rating}
#'   \item{y}{Subject-mean deviated relationship dissatisfaction}
#' }
#'
#' @source \url{http://www.intensivelongitudinal.com/datasets.html}
"BLch9"
