% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlm.R
\name{mlm}
\alias{mlm}
\title{Estimate a multilevel mediation model}
\usage{
mlm(
  d = NULL,
  id = "id",
  x = "x",
  m = "m",
  y = "y",
  priors = NULL,
  binary_y = FALSE,
  ...
)
}
\arguments{
\item{d}{A \code{data.frame} or a \code{data_frame}.}

\item{id}{Column of participant IDs in \code{data}.}

\item{x}{Column of X values in \code{data}.}

\item{m}{Column of M values in \code{data}.}

\item{y}{Column of Y values in \code{data}.}

\item{priors}{A list of named values to be used as the prior scale
parameters. See details.}

\item{binary_y}{Set to TRUE if y is binary and should be modelled
with logistic regression. Defaults to FALSE (y treated as continuous.)
This feature is experimental.}

\item{...}{Other optional parameters passed to \code{rstan::stan()}.}
}
\value{
An object of S4 class stanfit, with all its available methods.
}
\description{
Estimates a Bayesian multilevel mediation model using Stan.
}
\details{
Draw samples from the joint posterior distribution of a
multilevel mediation model using Stan.

\subsection{Priors}{

Users may pass a list of named values for the \code{priors} argument.
The values will be used to define the scale parameter of the
respective prior distributions.
This list may specify some or all of the following parameters:

\describe{
 \item{dy, dm}{Regression intercepts (for Y and M as outcomes, respectively.)}
 \item{a, b, cp}{Regression slopes.}
 \item{tau_x}{Varying effects SDs for above parameters (e.g replace x with a.)}
 \item{lkj_shape}{Shape parameter for the LKJ prior.}
}
See examples for specifying the following: Gaussian distributions with SD = 10
as priors for the intercepts, Gaussians with SD = 2 for the slopes,
Half-Cauchy distributions with scale parameters 1 for the varying effects
SDs, and an LKJ prior of 2.
}
}
\examples{
\dontrun{
## Run example from Bolger and Laurenceau (2013)
data(BLch9)
fit <- mlm(BLch9)
mlm_summary(fit)

### With priors
Priors <- list(dy = 10, dm = 10, a = 2, b = 2, cp = 2,
               tau_dy = 1, tau_dm = 1, tau_a = 1, tau_b = 1, tau_cp = 1,
               lkj_shape = 2)
fit <- mlm(BLch9, priors = Priors)
}

}
\author{
Matti Vuorre \email{mv2521@columbia.edu}
}
