% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/scalarClassificationLosses.R
\name{hingeLoss}
\alias{hingeLoss}
\title{Hinge Loss function for SVM}
\usage{
hingeLoss(x, y, loss.weights = 1)
}
\arguments{
\item{x}{matrix of training instances (one instance by row)}

\item{y}{numeric vector of values in (-1,+1) representing the training labels for each instance in x}

\item{loss.weights}{numeric vector of loss weights to incure for each instance of x in case of misprediction.
Vector length should match length(y), but values are cycled if not of identical size.
Default to 1 so we define a standard 0/1 loss for SVM classifier.
The parameter might be useful to adapt SVM learning in case of unbalanced class distribution.}
}
\value{
a function taking one argument w and computing the loss value and the gradient at point w
}
\description{
Hinge Loss function for SVM
}
\references{
Teo et al.
  A Scalable Modular Convex Solver for Regularized Risk Minimization.
  KDD 2007
}
\seealso{
bmrm
}

