% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactionlists.R
\name{annotateEdges}
\alias{annotateEdges}
\title{Annotating edges from discovered networks}
\usage{
annotateEdges(
  bnres,
  bnnames,
  sump = 1.2,
  minp = 0.5,
  minkp = 0.9,
  maxkp = NULL,
  dblist = NULL
)
}
\arguments{
\item{bnres}{an object of class 'bnclustOmics'; see \link{bnclustOmics}}

\item{bnnames}{an object of class 'bnInfo'; see \link{bnInfo}}

\item{sump}{threshold for the sum of posterior probabilities in all discovered networks}

\item{minp}{threshold for the minimum posterior probability in at least one network, when the sum of posterioirs is bigger than sump}

\item{minkp}{threshold for the minimum posterior probability in at least one network, when the sum of posterioirs is less than sump}

\item{maxkp}{(optional) threshold for the maximum posterior probability in at least one network; used to esclude cluster specific edges from the edges with high sum of posterioirs (>sump)}

\item{dblist}{a list of known interactions, discovered edges will be annotated is the edge is present in this list; two columns must be present 'gene1' and 'gene2'}
}
\value{
returns a data frame where each filteres interaction is annotated with IDs of omics variables, omics types, posterior probabilities of the interaction in the discovred clusters and a flag indication if the interaction could be found
in the interaction data base
}
\description{
This function makes a data frame which contains all pairs of nodes connected in cluster-specific networks
}
\examples{
bnnames<-bnInfo(simdata,c("b","c"),c("M","T"))
intlist<-annotateEdges(bnres3,bnnames,dblist=simint)
length(which(intlist$db))
}
