#' poultry Bayesian Network
#'
#' Practical application of a Bayesian network approach to poultry epigenetics and stress.
#'
#' @usage NULL
#'
#' @format
#' A discrete Bayesian network to provide further insights into the relationships among epigenetic features and a stressful condition in chickens. The Bayesian network is learned as in the referenced paper. The vertices are:
#' \describe{
#' \item{ARHGAP26}{(0,1);}
#' \item{BOP1}{(0,1);}
#' \item{CANX}{(0,1);}
#' \item{CWC25}{(0,1);}
#' \item{DGKD}{(0,1);}
#' \item{DMR1}{(0,1);}
#' \item{DMR2}{(0,1);}
#' \item{DMR5}{(0,1);}
#' \item{DMR6}{(0,1);}
#' \item{DMR7}{(0,1);}
#' \item{DOCK5}{(0,1);}
#' \item{EEPD1}{(0,1);}
#' \item{EFR3B}{(0,1);}
#' \item{ENS10218}{(0,1);}
#' \item{ENS27231}{(0,1);}
#' \item{ENS46425}{(0,1);}
#' \item{ENS47746}{(0,1);}
#' \item{ENS50012}{(0,1);}
#' \item{ENS50641}{(0,1);}
#' \item{ENS51236}{(0,1);}
#' \item{ENS53725}{(0,1);}
#' \item{FBN1}{(0,1);}
#' \item{GNAO1}{(0,1);}
#' \item{GRP141}{(0,1);}
#' \item{LOC101750642}{(0,1);}
#' \item{LOC770074}{(0,1);}
#' \item{LRP5}{(0,1);}
#' \item{MFSD4A}{(0,1);}
#' \item{MIP}{(0,1);}
#' \item{OCLN}{(0,1);}
#' \item{PAPK2}{(0,1);}
#' \item{PLXNA2}{(0,1);}
#' \item{POP5}{(0,1);}
#' \item{RP1_27O5_3}{(0,1);}
#' \item{SCHIP1}{(0,1);}
#' \item{SELENOI}{(0,1);}
#' \item{SHISA2}{(0,1);}
#' \item{SKOR2}{(0,1);}
#' \item{STAT3}{(0,1);}
#' \item{Stress}{(0,1);}
#' \item{TPST2}{(0,1);}
#' \item{TRMT10A}{(0,1);}
#' \item{TTLL9}{(0,1);}
#' \item{VGLL4}{(0,1);}
#' \item{XRCC4}{(0,1);}
#' \item{ZBTB48}{(0,1);}
#' \item{ZDHHC18}{(0,1);}
#'  }
#'
#' @return An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
#' @keywords NULL
#' @importClassesFrom bnlearn bn.fit
#' @references Videla Rodriguez, E. A., Pertille, F., Guerrero-Bosagna, C., Mitchell, J. B., Jensen, P., & Smith, V. A. (2022). Practical application of a Bayesian network approach to poultry epigenetics and stress. BMC Bioinformatics, 23(1), 261.
"poultry"
