% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/wrap-graph.R
\name{max_weight_forest}
\alias{max_weight_forest}
\title{Returns the undirected augmenting forest.}
\usage{
max_weight_forest(g)
}
\arguments{
\item{g}{\code{\link{graphNEL}} object. The undirected graph with pairwise
weights.}
}
\value{
A \code{\link{graphNEL}} object. The maximum spanning forest.
}
\description{
Uses Kruskal's algorithm to find the augmenting forest that maximizes the sum
of pairwise weights. When the weights are class-conditional mutual
information this forest maximizes the likelihood of the tree-augmented naive
Bayes network.
}
\details{
If \code{g} is not connected than this will return a forest; otherwise it is
a tree.
}
\references{
Friedman N, Geiger D and Goldszmidt M (1997). Bayesian network
  classifiers. \emph{Machine Learning}, \bold{29}, pp. 131--163.

  Murphy KP (2012). \emph{Machine learning: a probabilistic perspective}. The
  MIT Press. pp. 912-914.
}
\keyword{internal}

