% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0bnclassify-doc.R, R/learn-struct.R
\name{tan_chowliu}
\alias{tan_chowliu}
\alias{tan_cl}
\title{Learns a one-dependence estimator using Chow-Liu's algorithm.}
\usage{
tan_cl(class, dataset, score = "loglik", root = NULL)
}
\arguments{
\item{class}{A character. Name of the class variable.}

\item{dataset}{The data frame from which to learn the classifier.}

\item{score}{A character. The score to be maximized. \code{'loglik'}, 
\code{'bic'}, and \code{'aic'} return the maximum likelihood, maximum BIC 
and maximum AIC tree/forest, respectively.}

\item{root}{A character. The feature to be used as root of the augmenting 
tree. Only one feature can be supplied, even in case of an augmenting 
forest. This argument is optional.}
}
\value{
A \code{\link{bnc_dag}} object.
}
\description{
Learns a one-dependence Bayesian classifier using Chow-Liu's algorithm, by 
maximizing either log-likelihood, the AIC or BIC scores; maximizing 
log-likelihood corresponds to the well-known tree augmented naive Bayes 
(Friedman et al., 1997). When maximizing AIC or BIC the output might be a
forest-augmented rather than a tree-augmented naive Bayes.
}
\examples{
data(car)
ll <- tan_cl('class', car, score = 'loglik')   
plot(ll)
ll <- tan_cl('class', car, score = 'loglik', root = 'maint')   
plot(ll)
aic <- tan_cl('class', car, score = 'aic')   
bic <- tan_cl('class', car, score = 'bic')   
}
\references{
Friedman N, Geiger D and Goldszmidt M (1997). Bayesian network 
  classifiers. \emph{Machine Learning}, \bold{29}, pp. 131--163.
}
