% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.summary.R
\name{network.rank.tx.plot}
\alias{network.rank.tx.plot}
\title{Create a treatment rank plot}
\usage{
network.rank.tx.plot(
  result,
  txnames = NULL,
  catnames = NULL,
  legend.position = c(1, 1)
)
}
\arguments{
\item{result}{Object created by \code{\link{network.run}} function}

\item{txnames}{Treatment names used in creating legend}

\item{catnames}{Category names. Only used in multinomial.}

\item{legend.position}{x,y position of the legend}
}
\value{
None
}
\description{
This plot displays how each treatment is ranked. For each rank, we show how likely each treatment will be at that rank.
}
\examples{
network <-with(blocker, {
 network.data(Outcomes, Study, Treat, N = N, response = "binomial")
})
\donttest{
result <- network.run(network)
network.rank.tx.plot(result, txnames = c("a", "b"))
}
}
\seealso{
\code{\link{rank.tx}}
}
