% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.summary.R
\name{calculate.deviance}
\alias{calculate.deviance}
\title{Find deviance statistics such as DIC and pD.}
\usage{
calculate.deviance(result)
}
\arguments{
\item{result}{Object created by \code{\link{network.run}} function}
}
\value{
\item{Dbar}{Overall residual deviance}
\item{pD}{Sum of leverage_arm (i.e. total leverage)}
\item{DIC}{Deviance information criteria (sum of Dbar and pD)}
\item{data.points}{Total number of arms in the meta analysis}
\item{dev_arm}{Posterior mean of the residual deviance in each trial arm}
\item{devtilda_arm}{Deviance at the posterior mean of the fitted values}
\item{leverage_arm}{Difference between dev_arm and devtilda_arm for each trial}
\item{rtilda_arm}{Posterior mean of the fitted value for binomial and multinomial}
\item{ybar_arm}{Posterior mean of the fitted value for normal}
}
\description{
Calculates deviance statistics. This function automatically called in \code{\link{network.run}} and the deviance statistics are stored after sampling is finished.
}
\examples{
#parkinsons
network <- with(parkinsons, {
 network.data(Outcomes, Study, Treat, SE = SE, response = "normal")
})
\donttest{
result <- network.run(network)
calculate.deviance(result)
}
}
\references{
S. Dias, A.J. Sutton, A.E. Ades, and N.J. Welton (2013a), \emph{A Generalized Linear Modeling Framework for Pairwise and Network Meta-analysis of Randomized Controlled Trials}, Medical Decision Making 33(5):607-617. \doi{10.1177/0272989X12458724}
}
