% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpiaf.R
\name{rpiaf}
\alias{rpiaf}
\title{Construct individual-specific allele frequency matrix}
\usage{
rpiaf(B, Q)
}
\arguments{
\item{B}{The \eqn{m \times k}{m-by-k} intermediate subpopulation allele frequency matrix}

\item{Q}{The \eqn{n \times k}{n-by-k} admixture proportion matrix}
}
\value{
The \eqn{m \times n}{m-by-n} IAF matrix \eqn{P}
}
\description{
Here \eqn{m} is the number of loci, \eqn{n} the number of individuals, and \eqn{k} the number of intermediate subpopulations.
The \eqn{m \times n}{m-by-n} Individual-specific Allele Frequency (IAF) matrix \eqn{P} is constructed from the \eqn{m \times k}{m-by-k} intermediate subpopulation allele frequency matrix \eqn{B} and the \eqn{n \times k}{n-by-k} admixture proportion matrix \eqn{Q} using
\deqn{P = B Q^T.}{P = B * Q^T.}
}
\examples{
m <- 10 # number of loci
n <- 5 # number of individuals
k <- 2 # number of intermediate subpops
pAnc <- rpanc(m) # random vector of ancestral allele frequencies
F <- c(0.1, 0.3) # FST values for k=2 subpops
B <- rpint(pAnc, F) # matrix of intermediate subpop allele freqs
sigma <- 1 # dispersion parameter of intermediate subpops
Q <- q1d(n, k, sigma) # non-trivial admixture proportions
P <- rpiaf(B,Q)

}
