% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admix_prop_indep_subpops.R
\name{admix_prop_indep_subpops}
\alias{admix_prop_indep_subpops}
\title{Construct admixture proportion matrix for independent subpopulations}
\usage{
admix_prop_indep_subpops(labs, subpops)
}
\arguments{
\item{labs}{Length-\eqn{n} vector of subpopulation labels}

\item{subpops}{Optional length-\eqn{k} vector of unique subpopulations in desired order.
Stops if \code{subpops} does not contain all unique labels in \code{labs} (no error if \code{subpops} contains additional labels).}
}
\value{
The \eqn{n \times k}{n-by-k} admixture proportion matrix.
The unique subpopulation labels are given in the column names.
}
\description{
This function constructs an admixture proportion matrix where every individuals is actually unadmixed (draws its full ancestry from a single intermediate subpopulation).
The inputs are the vector of subpopulation labels \code{labs} for every individual (length \eqn{n}), and
the length-\eqn{k} vector of unique subpopulations \code{subpops} in the desired order.
If \code{subpops} is missing, the sorted unique subpopulations observed in \code{labs} is used.
This function returns the admixture proportion matrix, for each individual 1 for the column corresponding to its subpopulation, 0 otherwise.
}
\examples{
# vector of subpopulation memberships
labs <- c(1, 1, 1, 2, 2, 3, 1)
# admixture matrix with subpopulations (along columns) sorted
admix_proportions <- admix_prop_indep_subpops(labs)

# declare subpopulations in custom order
subpops <- c(3, 1, 2)
# columns will be reordered to match subpops as provided
admix_proportions <- admix_prop_indep_subpops(labs, subpops)

# declare subpopulations with unobserved labels
subpops <- 1:5
# note columns 4 and 5 will be false for all individuals
admix_proportions <- admix_prop_indep_subpops(labs, subpops)

}
