% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_p_ind_admix.R
\name{make_p_ind_admix}
\alias{make_p_ind_admix}
\title{Construct individual-specific allele frequency matrix under the PSD admixture model}
\usage{
make_p_ind_admix(p_subpops, admix_proportions)
}
\arguments{
\item{p_subpops}{The \code{m}-by-\code{k} matrix of intermediate subpopulation allele frequencies.}

\item{admix_proportions}{The \code{n}-by-\code{k} matrix of admixture proportions.}
}
\value{
The \code{m}-by-\code{n} matrix of individual-specific allele frequencies \code{p_ind}.
}
\description{
Here \code{m} is the number of loci, \code{n} the number of individuals, and \code{k} the number of intermediate subpopulations.
The \code{m}-by-\code{n} individual-specific allele frequency matrix \code{p_ind} is constructed from the \code{m}-by-\code{k} intermediate subpopulation allele frequency matrix \code{p_subpops} and the \code{n}-by-\code{k} admixture proportion matrix \code{admix_proportions} equivalent to
\code{p_ind <- p_subpops \%*\% t( admix_proportions )}.
This function is a wrapper around \verb{\link{tcrossprod}}, but also ensures the output allele frequencies are in [0, 1] (otherwise not guaranteed due to limited machine precision).
}
\examples{
# data dimensions
# number of loci
m_loci <- 10
# number of individuals
n_ind <- 5
# number of intermediate subpops
k_subpops <- 2

# FST values for k = 2 subpops
inbr_subpops <- c(0.1, 0.3)

# non-trivial admixture proportions
admix_proportions <- admix_prop_1d_linear(n_ind, k_subpops, sigma = 1)

# random vector of ancestral allele frequencies
p_anc <- draw_p_anc(m_loci)

# matrix of intermediate subpop allele freqs
p_subpops <- draw_p_subpops(p_anc, inbr_subpops)

# matrix of individual-specific allele frequencies
p_ind <- make_p_ind_admix(p_subpops, admix_proportions)

}
