% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/BN-methods.R
\docType{methods}
\name{wpdag.from.dag}
\alias{wpdag.from.dag}
\alias{wpdag.from.dag,BN}
\alias{wpdag.from.dag,BN-method}
\title{Initialize a WPDAG from a DAG.}
\usage{
wpdag.from.dag(x, layering = NULL)

\S4method{wpdag.from.dag}{BN}(x, layering = NULL)
}
\arguments{
\item{x}{a \code{\link{BN}} object.}

\item{layering}{vector containing the layers each node belongs to.}
}
\value{
a \code{\link{BN}} object with an initialized \code{wpdag}.
}
\description{
Given a \code{\link{BN}} object with a \code{dag}, return a network
with its \code{wpdag} set as the CPDAG computed starting from the \code{dag}.
}
\examples{
\dontrun{
net <- learn.network(dataset, layering=layering)
wp.net <- wpdag.from.dag(net, layering)
}

}
\seealso{
\code{\link{dag.to.cpdag}}
}

