"boa.init" <-
function()
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
{
   assign(".boa.par",
          list(acf.lags     = c(1, 5, 10, 50),
               alpha        = 0.05,
               bandwidth    = function(x)  0.5 * diff(range(x)) /
                                           (log(length(x)) + 1),
               batch.size   = 50,
               dev          = options()$device,
               dev.list     = numeric(0),
               ASCIIext     = ".txt",
               gandr.bins   = 20,
               gandr.win    = 0.5,
               geweke.bins  = 10,
               geweke.first = 0.1,
               geweke.last  = 0.5,
               handw.error  = 0.1,
               kernel       = "gaussian",
               legend       = TRUE,
               path         = "",
               plot.mfdim   = c(3, 2),
               plot.new     = FALSE,
               plot.onelink = FALSE,
               quantiles    = c(0.025, 0.5, 0.975),
               randl.error  = 0.005,
               randl.delta  = 0.001,
               randl.q      = 0.025,
               title        = "Bayesian Output Analysis"), envir = globalenv())
   assign(".boa.pardesc",
          structure(rbind(
             c("Analysis", "Brooks, Gelman & Rubin", "Alpha Level", "alpha",
               ""),
             c("Analysis", "Brooks, Gelman & Rubin", "Window Fraction",
               "gandr.win", ""),
             c("Analysis", "Geweke", "Window 1 Fraction", "geweke.first", ""),
             c("Analysis", "Geweke", "Window 2 Fraction", "geweke.last", ""),
             c("Analysis", "Heidelberger & Welch", "Accuracy", "handw.error",
               ""),
             c("Analysis", "Heidelberger & Welch", "Alpha Level", "alpha",
               ""),
             c("Analysis", "Raftery & Lewis", "Accuracy", "randl.error", ""),
             c("Analysis", "Raftery & Lewis", "Alpha Level", "alpha", ""),
             c("Analysis", "Raftery & Lewis", "Delta", "randl.delta", ""),
             c("Analysis", "Raftery & Lewis", "Quantile", "randl.q", ""),
             c("Analysis", "Statistics", "ACF Lags", "acf.lags", ""),
             c("Analysis", "Statistics", "Alpha Level", "alpha", ""),
             c("Analysis", "Statistics", "Batch Size", "batch.size", ""),
             c("Analysis", "Statistics", "Quantiles", "quantiles", ""),
             c("Data", "Files", "Working Directory", "path",
               "Specified directory must not end with a slash"),
             c("Data", "Files", "ASCII File Ext", "ASCIIext", ""),
             c("Plot", "Brooks & Gelman", "Number of Bins", "gandr.bins", ""),
             c("Plot", "Brooks & Gelman", "Window Fraction", "gandr.win", ""),
             c("Plot", "Density", "Bandwidth", "bandwidth",
               "This defines the standard deviation of the smoothing kernel"),
             c("Plot", "Density", "Kernel", "kernel",
               "Possible kernels are gaussian, rectangular, triangular, or cosine"),
             c("Plot", "Gelman & Rubin", "Alpha Level", "alpha", ""),
             c("Plot", "Gelman & Rubin", "Number of Bins", "gandr.bins", ""),
             c("Plot", "Gelman & Rubin", "Window Fraction", "gandr.win", ""),
             c("Plot", "Geweke", "Alpha Level", "alpha", ""),
             c("Plot", "Geweke", "Number of Bins", "geweke.bins", ""),
             c("Plot", "Geweke", "Window 1 Fraction", "geweke.first", ""),
             c("Plot", "Geweke", "Window 2 Fraction", "geweke.last", ""),
             c("Plot", "Graphics", "Device Name", "dev", ""),
             c("Plot", "Graphics", "Keep Previous Plots", "plot.new", ""),
             c("Plot", "Graphics", "Legend", "legend",
               "Include plot legends (T/F)"),
             c("Plot", "Graphics", "Plot Layout", "plot.mfdim", ""),
             c("Plot", "Graphics", "Separate Plot/Chain", "plot.onelink", ""),
             c("Plot", "Graphics", "Title", "title", "")),
             dimnames =
                list(NULL, c("group", "method", "desc", "par", "note"))),
          envir = globalenv())
   assign(".boa.chain",
          list(master         = list(),
               master.support = list(),
               work           = list(),
               work.support   = list(),
               work.sync      = TRUE), envir = globalenv())
   assign(".boa.version",
          list(name     = "BOA",
               major    = 1,
               minor    = 1,
               revision = 1,
               system   = version$system), envir = globalenv())
   boa.license()
   invisible()
}
