% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ag_bulletin.R
\name{get_ag_bulletin}
\alias{get_ag_bulletin}
\title{Get BOM Agriculture Bulletin Information for Select Stations}
\usage{
get_ag_bulletin(state = "AUS")
}
\arguments{
\item{state}{Australian state or territory as full name or postal code.
Fuzzy string matching via \code{\link[base]{agrep}} is done.  Defaults to
"AUS" returning all state bulletins, see details for more.}
}
\value{
Tidy data frame of a Australia BOM agricultural bulletin information.  For
full details of fields and units returned see Appendix 3 in the
\pkg{bomrang} vignette, use \cr
\code{vignette("bomrang", package = "bomrang")} to view.
}
\description{
Fetch the BOM agricultural bulletin information and return it in a tidy data
frame
}
\details{
Allowed state and territory postal codes, only one state per request
or all using \code{AUS}.
 \describe{
   \item{NSW}{New South Wales}
   \item{NT}{Northern Territory}
   \item{QLD}{Queensland}
   \item{SA}{South Australia}
   \item{TAS}{Tasmania}
   \item{VIC}{Victoria}
   \item{WA}{Western Australia}
   \item{AUS}{Australia, returns bulletin for all states and NT}
 }
}
\examples{
\dontrun{
ag_bulletin <- get_ag_bulletin(state = "QLD")
}

}
\references{
Agricultural observations are retrieved from the Australian Bureau of
Meteorology (BOM) Weather Data Services Agriculture Bulletins, \cr
\url{http://www.bom.gov.au/catalogue/observations/about-agricultural.shtml}

and

Australian Bureau of Meteorology (BOM) Weather Data Services Observation of
Rainfall, \cr
\url{http://www.bom.gov.au/climate/how/observations/rain-measure.shtml}

Station location and other metadata are sourced from the Australian Bureau of
Meteorology (BOM) webpage, Bureau of Meteorology Site Numbers: \cr
\url{http://www.bom.gov.au/climate/cdo/about/site-num.shtml}
}
\author{
Adam H Sparks, \email{adamhsparks@gmail.com}
}
