% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subgroups.R
\name{subgroups}
\alias{subgroups}
\title{Subgroup Treatment Effect}
\usage{
subgroups(object, est_coef, h0 = NULL, gamma = 1)
}
\arguments{
\item{object}{(\code{bonsaiforest})\cr the fitted bonsaiforest object.}

\item{est_coef}{(\code{matrix})\cr the estimated coefficients from the fitted
model.}

\item{h0}{(\code{numeric})\cr the vector with the cumulative baseline hazard.
Present just for \code{resptype} survival.}

\item{gamma}{(\code{scalar})\cr numeric value defining the weights to obtain
the average hazard ratio. Default is 1 (in this case the average hazard
ratio obtained can be interpreted as the odds of concordance).}
}
\value{
\code{data.frame} with the subgroup names and with the estimated subgroup
treatment effects.
}
\description{
Function to obtain the estimated treatment effect in each one of the
considered subgroups.
}
\examples{
subgroups(
  elastic_net_fit_surv, elastic_net_surv$est_coef,
  elastic_net_surv$h0
)
}
