% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html.R
\name{resolve_refs_html}
\alias{resolve_refs_html}
\title{Resolve figure/table/section references in HTML}
\usage{
resolve_refs_html(content, global = FALSE)
}
\arguments{
\item{content}{A character vector of the HTML content.}

\item{global}{Whether to number the elements incrementally throughout the
whole document, or number them by the first-level headers. For an R
Markdown output format, \code{global = !number_sections} is likely to be a
reasonable default (i.e., when the sections are numbered, you number
figures/tables by sections; otherwise just number them incrementally).}
}
\value{
A post-processed character vector of the HTML character.
}
\description{
Post-process the HTML content to resolve references of figures, tables, and
sections, etc. The references are written in the form \code{\@ref(key)} in
the R Markdown source document.
}
\examples{
library(bookdown)
resolve_refs_html(c("<caption>(#tab:foo) A nice table.</caption>", 
    "<p>See Table @ref(tab:foo).</p>"), TRUE)
}
\keyword{internal}
