% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs4_book.R
\name{bs4_book}
\alias{bs4_book}
\alias{bs4_book_theme}
\title{HTML book built with bootstrap4}
\usage{
bs4_book(
  theme = bs4_book_theme(),
  repo = NULL,
  ...,
  lib_dir = "libs",
  pandoc_args = NULL,
  extra_dependencies = NULL,
  split_bib = FALSE
)

bs4_book_theme(primary = "#0068D9", version = 4, ...)
}
\arguments{
\item{theme}{A named list or \code{\link[bslib:bs_theme]{bslib::bs_theme()}} object.
The default, \code{bs4_book_theme()}, resets the base font size to 1rem to
make reading easier and uses a primary colour with greater contrast
against the background.}

\item{repo}{Either link to repository where book is hosted, used to generate
view source and edit buttons or a list with repository \code{base} link, default
\code{branch}, \code{subdir} and \code{icon}
(see "Specifying the repository" in \url{https://bookdown.org/yihui/bookdown/html.html#bootstrap4-style}).}

\item{lib_dir, pandoc_args, extra_dependencies, split_bib, ...}{Passed on to
\code{\link[rmarkdown:html_document]{rmarkdown::html_document()}}.}

\item{primary}{Primary colour: used for links and background of footer.}

\item{version}{Passed to \code{\link[bslib:bs_theme]{bslib::bs_theme()}}. This should not be changed as
\code{\link[=bs4_book]{bs4_book()}} has been designed to work with Bootstrap version 4 for now.}
}
\description{
This output format is built with \href{https://getbootstrap.com}{Bootstrap},
using carefully crafted features to provide a clean reading experience whether
you are on a phone, tablet, or desktop. To read more about this format, see:
\url{https://bookdown.org/yihui/bookdown/html.html#bootstrap4-style}
}
