% Generated by roxygen2 (4.0.0): do not edit by hand
\name{wrapProcedure}
\alias{wrapProcedure}
\title{Create a boostr compatible wrapper for an estimation procedure.}
\usage{
wrapProcedure(proc, learningSet = "data", predictionSet = "newdata")
}
\arguments{
\item{proc}{a function that obeys the definition of an estimation procedure
as defined in the white paper. Generally, \code{proc} must be a function
which learns some model and consequently returns an estimator that uses the
learned model. See below.}

\item{learningSet}{a string indicating the name of the argument in
\code{proc}'s signature that passes the data to be used inside \code{proc}.}

\item{predictionSet}{a string indicating the name of the argument in
\code{predict}'s signature that indicates the observation to predicate
responses for.}
}
\value{
An '\code{estimationProcedure}' object whose signature and whose
output's signature are compatible with boostr. Explicitly, the arguments of
the wrapper are
\item{data}{the data that \code{proc} will use to build a model.}
\item{...}{any additional arguments necessary for \code{proc} to make its
model.}
and the returned closure from the wrapper has arguments
\item{newdata}{the data that \code{proc}'s output will predict responses for.}
\item{.estimatorArgs}{a named list of any additional arguments that need to
be passed to \code{proc}'s output.}
}
\description{
Use provided metadata on a given estimation procedure to create
a boostr compatible wrapper. See section below for more details on estimation
procedures.
}
\section{Estimation Procedures}{


The examples below demonstrate two typical estimation procedures. For more
information, see the Estimation Procedures section in the vignette
\code{vignette(topic = "boostr_user_inputs", package="boostr")}.
}
\examples{
\dontrun{
 # examples of estimation procedures
 library(class)
 library(e1071)

  kNN <- function(data, formula, k) {
   df <- model.frame(formula=formula, data=data)
   function(newdata) {
     knn(train=df[, -1], test=newdata, cl=df[, 1], k=k)
   }
  }

  SVM <- function(data, formula, cost) {
   model <- svm(formula, data, cost=cost)
   function(newdata) {
     predict(model, newdata)
   }
  }
}
}
\references{
Steven Pollack. (2014). Boost: a practical generalization of AdaBoost
(Master's Thesis). \url{http://pollackphoto.net/misc/masters_thesis.pdf}
}
\seealso{
Other Wrapper Generators: \code{\link{buildEstimationProcedure}};
  \code{\link{wrapAggregator}};
  \code{\link{wrapPerformanceAnalyzer}};
  \code{\link{wrapReweighter}}
}

