% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul_data_UniYX_gamma.R
\name{simul_data_UniYX_gamma}
\alias{simul_data_UniYX_gamma}
\title{Data generating function for univariate gamma plsR models}
\usage{
simul_data_UniYX_gamma(totdim, ncomp, jvar, lvar, link = "inverse", offset = 0)
}
\arguments{
\item{totdim}{Number of columns of the X vector (from \code{ncomp} to
hardware limits)}

\item{ncomp}{Number of latent components in the model (to use noise, select ncomp=3)}

\item{jvar}{First variance parameter}

\item{lvar}{Second variance parameter}

\item{link}{Character specification of the link function in the mean model
(mu). Currently, "\code{inverse}", "\code{log}" and "\code{identity}" are supported.
Alternatively, an object of class "link-glm" can be supplied.}

\item{offset}{Offset on the linear scale}
}
\value{
\item{vector}{\eqn{(Ygamma,X_1,\ldots,X_{totdim})}}
}
\description{
This function generates a single univariate gamma response value \eqn{Ygamma}
and a vector of explanatory variables \eqn{(X_1,\ldots,X_{totdim})} drawn
from a model with a given number of latent components.
}
\details{
This function should be combined with the replicate function to give rise to
a larger dataset. The algorithm used is a modification of a port of the one
described in the article of Li which is a multivariate generalization of the
algorithm of Naes and Martens.
}
\examples{
set.seed(314)
ncomp=rep(3,100)
totdimpos=7:50
totdim=sample(totdimpos,100,replace=TRUE)
l=3.01
#for (l in seq(3.01,15.51,by=0.5)) {
j=3.01
#for (j in seq(3.01,9.51,by=0.5))  {
i=44
#for ( i in 1:100){
set.seed(i)
totdimi<-totdim[i]
ncompi<-ncomp[i]
datasim <- t(replicate(200,simul_data_UniYX_gamma(totdimi,ncompi,j,l)))
#}
#}
#}
pairs(datasim)
rm(i,j,l,totdimi,ncompi,datasim)
}
\references{
T. Naes, H. Martens, Comparison of prediction methods for
multicollinear data, Commun. Stat., Simul. 14 (1985) 545-576.\cr
%\url{http://dx.doi.org/10.1080/03610918508812458}\cr Baibing Li, Julian
Morris, Elaine B. Martin, Model selection for partial least squares
regression, Chemometrics and Intelligent Laboratory Systems 64 (2002), 
79-89, \doi{10.1016/S0169-7439(02)00051-5}.

A new bootstrap-based stopping criterion in PLS component construction,
J. Magnanensi, M. Maumy-Bertrand, N. Meyer and F. Bertrand (2016), in The Multiple Facets of Partial Least Squares and Related Methods, 
\doi{10.1007/978-3-319-40643-5_18}\cr

A new universal resample-stable bootstrap-based stopping criterion for PLS component construction,
J. Magnanensi, F. Bertrand, M. Maumy-Bertrand and N. Meyer, (2017), Statistics and Compututing, 27, 757–774. 
\doi{10.1007/s11222-016-9651-4}\cr

New developments in Sparse PLS regression, J. Magnanensi, M. Maumy-Bertrand, 
N. Meyer and F. Bertrand, (2021), Frontiers in Applied Mathematics and Statistics, 
accepted.
}
\seealso{
\code{\link[plsRglm]{simul_data_UniYX}}
}
\author{
Jeremy Magnanensi, Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{https://fbertran.github.io/homepage/}

Jérémy Magnanensi, Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{datagen}
\keyword{utilities}
