% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.r
\name{script_path}
\alias{script_path}
\alias{set_script_path}
\title{Set the base path of the script}
\usage{
\special{box::set_script_path(path)}

\special{box::script_path()}
}
\arguments{
\item{path}{character string containing the relative or absolute path to the
currently executing \R code file, or \code{NULL} to reset the path.}
}
\value{
Both \code{box::script_path} and \code{box::set_script_path} return
the previously set script path, or \code{NULL} if none was explicitly set.
\code{box::set_script_path} returns its value invisibly.
}
\description{
\code{box::set_script_path(path)} explicitly tells \pkg{box} the path of a
given script from which it is called; \code{box::script_path()} returns the
previously set path.
}
\details{
\pkg{box} needs to know the base path of the topmost calling \R context (i.e.
the script) to find relative import locations. In most cases, \pkg{box} can
figure the path out automatically. However, in some cases third-party
packages load code in a way in which \pkg{box} cannot find the correct path
of the script any more. \code{box::set_script_path} can be used in these
cases to set the path of the currently executing \R script manually.
}
\note{
\pkg{box} \emph{should} be able to figure out the script path automatically.
Using \code{box::set_script_path} should therefore never be necessary.
\href{https://github.com/klmr/box/issues/new?assignees=&labels=\%E2\%9A\%A0\%EF\%B8\%8F+bug&title=\%5Bset_script_path\%5D\%20&template=bug-report.yml}{Please
file an issue} if you encounter a situation that necessitates using
\code{box::set_script_path}!
}
\examples{
box::set_script_path('scripts/my_script.r')
}
