% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxr_auth.R
\name{box_auth_service}
\alias{box_auth_service}
\title{Authenticate to Box (service-app)}
\usage{
box_auth_service(token_file = NULL, token_text = NULL)
}
\arguments{
\item{token_file}{\code{character}, path to JSON token-file. If not provided,
the function will look for an environment variable \code{BOX_TOKEN_FILE}. If
that is not there, it will try \verb{~/.boxr-auth/token.json}.}

\item{token_text}{\code{character}, JSON text. If this is provided,
\code{token_file} is ignored.}
}
\value{
Invisible \code{NULL}, called for side effects.
}
\description{
How you authenticate to Box depends the Box-app through which you
connect. A Box service-app can be useful for unattended jobs that need
access to only a limited part of Box, e.g. one folder.

Use this function to access Box using a service-app.

To access a service-app, you will need a JSON web-token (JWT),
generated by your Box-admin team. If you have a personal Box account, \emph{you}
are your Box-admin team. You specify the JWT either as \code{token_file},
the path to the JWT file, or as \code{token_text}, the text of the JWT.

Using JWT-authentication is more convenient than using standard OAuth2
authentication, as you do not have to go through the "OAuth Dance". This
convenience brings additional considerations because the JWT file gives
its bearer uninhibited access to anything the Box service-app can access.
Accordingly, you are recommended to:
\itemize{
\item give the service-account access to as little information as you need it
to have, e.g. a single folder.
\item keep the JWT file secure.
}
}
\details{
The default behavior of a service-app is to act on behalf of the
service-account associated with the service-app. This is different
from an interactive-app, which acts on behalf of the Box user who
authenticates to it.

To use a service-app on a folder belonging to a Box user, either
the Box user has to invite the service-account to collaborate on a
folder belonging to the user, or the service-account has to invite the
Box user to collaborate on a folder belonging to the service-account.

In either case, you can use \code{box_collab_create()}.

In mid-2020, there appeared intermittent and unexplained failures of
\code{box_auth_service()}; the theory is that the clocks at either end
of the authentication process can be out-of-sync. The workaround
is to watch for this failure, then retry the authentication request
with a time-offset. If an offset is used, this function generates a message.

For more details on Box service-apps, including how to create them, and
service-app-based workflows, please read this boxr
\href{https://r-box.github.io/boxr/articles/boxr-app-service.html}{service-app article}.
}
\section{Side-effects}{

This function has some side effects:
\itemize{
\item some global \code{\link[=options]{options()}} are set for your session to manage the token.
\item a message is printed to the console.
}
}

\seealso{
\describe{
\item{\code{\link[=box_auth]{box_auth()}}}{for authenticating to interactive-apps.}
\item{\code{\link[=box_collab_create]{box_collab_create()}}}{for creating a collaboration with a different account
on a Box file or folder.}
\item{\href{https://developer.box.com/en/guides/applications/custom-apps/jwt-setup}{Box Developers: Setup with JWT}}{
documentation for setting up Box (service) apps with JWT.}
}
}
