% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{coef_lin.bpnme}
\alias{coef_lin.bpnme}
\title{Obtain the linear coefficients of a Bayesian circular mixed-effects model}
\usage{
\method{coef_lin}{bpnme}(object)
}
\arguments{
\item{object}{a \code{bpnme object} obtained from the function
\code{\link{bpnme}}.}
}
\value{
A matrix with posterior summaries of the linear coefficients in a
  Bayesian circular mixed-effects model.
}
\description{
Gives the coefficients tables of the linear coefficients for a Bayesian
circular mixed-effects model.
}
\examples{
library(bpnreg)
fit.Maps <- bpnme(pred.I = Error.rad ~ Maze + Trial.type + L.c + (1|Subject),
data = Maps,
its = 100, burn = 1, n.lag = 1)
coef_lin(fit.Maps)

}
