% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRI.R
\name{logmargLikelihood_or1}
\alias{logmargLikelihood_or1}
\title{Marginal Likelihood for Ordinal Model
with more than 3 outcomes}
\usage{
logmargLikelihood_or1(
  y,
  x,
  b0,
  B0,
  d0,
  D0,
  postMeanbeta,
  postMeandelta,
  beta,
  delta,
  tune,
  Dhat,
  p
)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones with or without column names.}

\item{b0}{prior mean for normal distribution to sample \eqn{\beta}.}

\item{B0}{prior variance for normal distribution to sample \eqn{\beta}}

\item{d0}{prior mean for covariance matrix of normal distribution to sample \eqn{\delta}.}

\item{D0}{prior variance for normal distribution to sample \eqn{\delta}.}

\item{postMeanbeta}{a vector with mean of sampled \eqn{\beta} for each covariate.}

\item{postMeandelta}{a vector with mean of sampled \eqn{\delta} for each cut-point.}

\item{beta}{a storage matrix with all sampled values for \eqn{\beta}.}

\item{delta}{a storage matrix with all sampled values for \eqn{\delta}.}

\item{tune}{tuning parameter to adjust MH acceptance rate.}

\item{Dhat}{negative inverse Hessian from maximization of log-likelihood.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a scalar for marginal likelihood
}
\description{
This function estimates the marginal likelihood for ordinal model with
more than 3 outcomes
}
\details{
Function implements the marginal likelihood for
ordinal models with more than 3 outcomes using a combination of Gibbs sampling
and Metropolis-Hastings algorithm.
}
\examples{
set.seed(101)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
k <- dim(x)[2]
J <- dim(as.array(unique(y)))[1]
D0 <- 0.25*diag(J - 2)
output <- quantreg_or1(y = y,x = x, B0 = 10*diag(k), D0 = D0,
mcmc = 50, p = 0.25, tune = 1)
# output$logMargLikelihood
#   -572.54

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.
}
\seealso{
\link[NPflow]{mvnpdf}, \link[stats]{dnorm},
Gibbs sampling, Metropolis-Hastings algorithm
}
