% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{drawsigmaOR2}
\alias{drawsigmaOR2}
\title{Samples \eqn{\sigma} in the OR2 model}
\usage{
drawsigmaOR2(z, x, beta, nu, tau2, theta, n0, d0)
}
\arguments{
\item{z}{Gibbs draw of continuous latent values, a column vector of size \eqn{n x 1}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{beta}{Gibbs draw of \eqn{\beta}, a column vector of size \eqn{(k x 1)}.}

\item{nu}{modified latent weight, column vector of size \eqn{(n x 1)}.}

\item{tau2}{2/(p(1-p)).}

\item{theta}{(1-2p)/(p(1-p)).}

\item{n0}{prior hyper-parameter for \eqn{\sigma}.}

\item{d0}{prior hyper-parameter for \eqn{\sigma}.}
}
\value{
Returns a list with components
\itemize{
\item{\code{sigma}: }{\eqn{\sigma}, a scalar, sampled
from an inverse gamma distribution.}
\item{\code{dtilde}: }{scale parameter of the inverse-gamma distribution.}
}
}
\description{
This function samples \eqn{\sigma} from an inverse-gamma distribution
in the OR2 model (ordinal quantile model with exactly 3 outcomes).
}
\details{
This function samples \eqn{\sigma} from an inverse-gamma distribution.
}
\examples{
set.seed(101)
z <- c(21.01744, 33.54702, 33.09195, -3.677646,
 21.06553, 1.490476, 0.9618205, -6.743081, 21.02186, 0.6950479)
x <- matrix(c(
     1, -0.3010490, 0.8012506,
     1,  1.2764036, 0.4658184,
     1,  0.6595495, 1.7563655,
     1, -1.5024607, -0.8251381,
     1, -0.9733585, 0.2980610,
     1, -0.2869895, -1.0130274,
     1,  0.3101613, -1.6260663,
     1, -0.7736152, -1.4987616,
     1,  0.9961420, 1.2965952,
     1, -1.1372480, 1.7537353),
     nrow = 10, ncol = 3, byrow = TRUE)
beta <- c(-0.74441, 1.364846, 0.7159231)
n <- dim(x)[1]
nu <- array(5 * rep(1,n), dim = c(n, 1))
tau2 <- 10.6667
theta <- 2.6667
n0 <- 5
d0 <- 8
output <- drawsigmaOR2(z, x, beta, nu, tau2, theta, n0, d0)

# output$sigma
#   3.749524

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.  DOI: 10.1214/15-BA939

Devroye, L. (2014). “Random variate generation for the generalized inverse Gaussian
distribution.” Statistics and Computing, 24(2): 239–246. DOI: 10.1007/s11222-012-9367-z
}
\seealso{
\link[stats]{rgamma}, Gibbs sampling
}
