% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{logMargLikeOR2}
\alias{logMargLikeOR2}
\title{Marginal likelihood in the OR2 model}
\usage{
logMargLikeOR2(y, x, b0, B0, n0, d0, postMeanbeta, postMeansigma,
btildeStore, BtildeStore, gammacp2, p, verbose)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{b0}{prior mean for \eqn{\beta}.}

\item{B0}{prior covariance matrix for \eqn{\beta}.}

\item{n0}{prior shape parameter of inverse-gamma distribution for \eqn{\sigma}.}

\item{d0}{prior scale parameter of inverse-gamma distribution for \eqn{\sigma}.}

\item{postMeanbeta}{posterior mean of \eqn{\beta} from the complete Gibbs run.}

\item{postMeansigma}{posterior mean of \eqn{\delta} from the complete Gibbs run.}

\item{btildeStore}{a storage matrix for btilde from the complete Gibbs run.}

\item{BtildeStore}{a storage matrix for Btilde from the complete Gibbs run.}

\item{gammacp2}{one and only cut-point other than 0.}

\item{p}{quantile level or skewness parameter, p in (0,1).}

\item{verbose}{whether to print the final output and provide additional information or not, default is TRUE.}
}
\value{
Returns an estimate of log marginal likelihood
}
\description{
This function computes the logarithm of marginal likelihood in the OR2 model (ordinal
quantile model with exactly 3 outcomes) using the Gibbs output from the
complete and reduced runs.
}
\details{
This function computes the logarithm of marginal likelihood in the OR2 model using the Gibbs output from the complete
and reduced runs.
}
\examples{
set.seed(101)
data("data25j3")
y <- data25j3$y
xMat <- data25j3$x
k <- dim(xMat)[2]
b0 <- array(rep(0, k), dim = c(k, 1))
B0 <- 10*diag(k)
n0 <- 5
d0 <- 8
output <- quantregOR2(y = y, x = xMat, b0, B0, n0, d0, gammacp2 = 3,
burn = 10, mcmc = 40, p = 0.25, accutoff = 0.5, maxlags = 400, verbose = FALSE)
# output$logMargLike
#   -404.57

}
\references{
Chib, S. (1995). `"Marginal likelihood from the Gibbs output."` Journal of the American
Statistical Association, 90(432):1313`-`1321, 1995. DOI: 10.1080/01621459.1995.10476635
}
\seealso{
\link[invgamma]{dinvgamma}, \link[NPflow]{mvnpdf}, \link[stats]{dnorm},
Gibbs sampling
}
